/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TokensInheritanceStrategy;
import java.util.concurrent.ScheduledExecutorService;

public class LimitChecker {
    public static long INFINITY_DURATION = Long.MAX_VALUE;
    public static long UNLIMITED_AMOUNT = Long.MAX_VALUE;

    public static void checkTokensToAdd(long tokensToAdd) {
        if (tokensToAdd <= 0L) {
            throw new IllegalArgumentException("tokensToAdd should be >= 0");
        }
    }

    public static void checkTokensToConsume(long tokensToConsume) {
        if (tokensToConsume <= 0L) {
            throw BucketExceptions.nonPositiveTokensToConsume(tokensToConsume);
        }
    }

    public static void checkMaxWaitTime(long maxWaitTimeNanos) {
        if (maxWaitTimeNanos <= 0L) {
            throw BucketExceptions.nonPositiveNanosToWait(maxWaitTimeNanos);
        }
    }

    public static void checkScheduler(ScheduledExecutorService scheduler) {
        if (scheduler == null) {
            throw BucketExceptions.nullScheduler();
        }
    }

    public static void checkConfiguration(BucketConfiguration newConfiguration) {
        if (newConfiguration == null) {
            throw BucketExceptions.nullConfiguration();
        }
    }

    public static void checkMigrationMode(TokensInheritanceStrategy tokensInheritanceStrategy) {
        if (tokensInheritanceStrategy == null) {
            throw BucketExceptions.nullTokensInheritanceStrategy();
        }
    }
}

