/*
 * Decompiled with CFR 0.152.
 */
package com.signalfx.shaded.jetty.client;

import com.signalfx.shaded.jetty.client.HttpRequest;
import com.signalfx.shaded.jetty.client.api.Request;
import com.signalfx.shaded.jetty.client.api.Response;
import com.signalfx.shaded.jetty.client.api.Result;
import com.signalfx.shaded.jetty.io.CyclicTimeout;
import com.signalfx.shaded.jetty.util.log.Log;
import com.signalfx.shaded.jetty.util.log.Logger;
import com.signalfx.shaded.jetty.util.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

@Deprecated
public class TimeoutCompleteListener
extends CyclicTimeout
implements Response.CompleteListener {
    private static final Logger LOG = Log.getLogger(TimeoutCompleteListener.class);
    private final AtomicReference<Request> requestTimeout = new AtomicReference();

    public TimeoutCompleteListener(Scheduler scheduler) {
        super(scheduler);
    }

    @Override
    public void onTimeoutExpired() {
        Request request = this.requestTimeout.getAndSet(null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Total timeout {} ms elapsed for {} on {}", request.getTimeout(), request, this);
        }
        if (request != null) {
            request.abort(new TimeoutException("Total timeout " + request.getTimeout() + " ms elapsed"));
        }
    }

    @Override
    public void onComplete(Result result) {
        Request request = this.requestTimeout.getAndSet(null);
        if (request != null) {
            boolean cancelled = this.cancel();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cancelled ({}) timeout for {} on {}", cancelled, request, this);
            }
        }
    }

    void schedule(HttpRequest request, long timeoutAt) {
        if (this.requestTimeout.compareAndSet(null, request)) {
            long delay = Math.max(0L, timeoutAt - System.nanoTime());
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {} on {}", TimeUnit.NANOSECONDS.toMillis(delay), request, this);
            }
            this.schedule(delay, TimeUnit.NANOSECONDS);
        }
    }
}

