/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.actions;

import java.util.Arrays;
import org.apereo.cas.web.flow.actions.ConsumerExecutionAction;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.binding.message.Severity;
import org.springframework.webflow.execution.RequestContext;

public class PopulateMessageContextAction {
    private static void addMessage(String[] codes, RequestContext requestContext, Severity severity) {
        Arrays.stream(codes).forEach(code -> {
            MessageResolver message = switch (severity) {
                default -> throw new MatchException(null, null);
                case Severity.INFO -> new MessageBuilder().info().code(code).build();
                case Severity.FATAL, Severity.ERROR -> new MessageBuilder().error().code(code).build();
                case Severity.WARNING -> new MessageBuilder().warning().code(code).build();
            };
            requestContext.getMessageContext().addMessage(message);
        });
    }

    public static class Info
    extends ConsumerExecutionAction {
        public Info(String ... codes) {
            super((RequestContext requestContext) -> PopulateMessageContextAction.addMessage(codes, requestContext, Severity.INFO));
        }
    }

    public static class Errors
    extends ConsumerExecutionAction {
        public Errors(String ... codes) {
            super((RequestContext requestContext) -> PopulateMessageContextAction.addMessage(codes, requestContext, Severity.ERROR));
        }
    }

    public static class Warning
    extends ConsumerExecutionAction {
        public Warning(String ... codes) {
            super((RequestContext requestContext) -> PopulateMessageContextAction.addMessage(codes, requestContext, Severity.WARNING));
        }
    }
}

