/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.imap;

import com.icegreen.greenmail.foedus.util.MsgRangeFilter;
import com.icegreen.greenmail.imap.ImapSession;
import com.icegreen.greenmail.imap.commands.IdRange;
import com.icegreen.greenmail.mail.MovingMessage;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.FolderListener;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.store.StoredMessage;
import jakarta.mail.Flags;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.UIDFolder;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.search.SearchTerm;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ImapSessionFolder
implements MailFolder,
FolderListener,
UIDFolder {
    private MailFolder folder;
    private ImapSession session;
    private boolean readonly;
    private volatile boolean sizeChanged;
    private final List<Integer> expungedMsns = Collections.synchronizedList(new LinkedList());
    private final Map<Integer, FlagUpdate> modifiedFlags = Collections.synchronizedMap(new TreeMap());

    public ImapSessionFolder(MailFolder folder, ImapSession session, boolean readonly) {
        this.folder = folder;
        this.session = session;
        this.readonly = readonly;
        this.folder.addListener(this);
    }

    public void deselect() {
        this.folder.removeListener(this);
        this.folder = null;
    }

    @Override
    public int getMsn(long uid) throws FolderException {
        long[] uids = this.folder.getMessageUids();
        for (int i = 0; i < uids.length; ++i) {
            long messageUid = uids[i];
            if (uid != messageUid) continue;
            return i + 1;
        }
        throw new FolderException("No such message with uid " + uid + " in folder " + this.folder.getName());
    }

    @Override
    public void signalDeletion() {
        this.folder.signalDeletion();
    }

    @Override
    public List<StoredMessage> getMessages(MsgRangeFilter msgRangeFilter) {
        return this.folder.getMessages(msgRangeFilter);
    }

    @Override
    public List<StoredMessage> getMessages() {
        return this.folder.getMessages();
    }

    @Override
    public List<StoredMessage> getNonDeletedMessages() {
        return this.folder.getNonDeletedMessages();
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getExpunged() {
        List<Integer> list = this.expungedMsns;
        synchronized (list) {
            int[] expungedMsnsArray = new int[this.expungedMsns.size()];
            for (int i = 0; i < expungedMsnsArray.length; ++i) {
                int msn;
                expungedMsnsArray[i] = msn = this.expungedMsns.get(i).intValue();
            }
            this.expungedMsns.clear();
            if (!this.modifiedFlags.isEmpty() || this.sizeChanged) {
                throw new IllegalStateException("Need to do this properly...");
            }
            return expungedMsnsArray;
        }
    }

    public List<FlagUpdate> getFlagUpdates() {
        if (this.modifiedFlags.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<FlagUpdate> retVal = new ArrayList<FlagUpdate>(this.modifiedFlags.values());
        this.modifiedFlags.clear();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expunged(int msn) {
        List<Integer> list = this.expungedMsns;
        synchronized (list) {
            this.expungedMsns.add(msn);
        }
    }

    @Override
    public void added(int msn) {
        this.sizeChanged = true;
    }

    @Override
    public void flagsUpdated(int msn, Flags flags, Long uid) {
        this.modifiedFlags.put(msn, new FlagUpdate(msn, uid, flags));
    }

    @Override
    public void mailboxDeleted() {
        this.session.closeConnection("Mailbox " + this.folder.getName() + " has been deleted");
    }

    @Override
    public String getName() {
        return this.folder.getName();
    }

    @Override
    public String getFullName() {
        return this.folder.getFullName();
    }

    @Override
    public Flags getAvailableFlags() {
        return this.folder.getAvailableFlags();
    }

    @Override
    public Flags getPermanentFlags() {
        return this.folder.getPermanentFlags();
    }

    @Override
    public int getMessageCount() {
        return this.folder.getMessageCount();
    }

    @Override
    public int getRecentCount(boolean reset) {
        return this.folder.getRecentCount(reset);
    }

    @Override
    public long getUidValidity() {
        return this.folder.getUidValidity();
    }

    @Override
    public int getFirstUnseen() {
        return this.correctForExpungedMessages(this.folder.getFirstUnseen());
    }

    private int correctForExpungedMessages(int absoluteMsn) {
        int correctedMsn = absoluteMsn;
        for (int i = this.expungedMsns.size() - 1; i >= 0; --i) {
            int expunged = this.expungedMsns.get(i);
            if (expunged > absoluteMsn) continue;
            ++correctedMsn;
        }
        return correctedMsn;
    }

    @Override
    public boolean isSelectable() {
        return this.folder.isSelectable();
    }

    @Override
    public int getUnseenCount() {
        return this.folder.getUnseenCount();
    }

    @Override
    public long appendMessage(MimeMessage message, Flags flags, Date receivedDate) {
        return this.folder.appendMessage(message, flags, receivedDate);
    }

    @Override
    public void store(MovingMessage mail) throws Exception {
        this.folder.store(mail);
    }

    @Override
    public void store(MimeMessage mail) throws Exception {
        this.folder.store(mail);
    }

    @Override
    public StoredMessage getMessage(long uid) {
        return this.folder.getMessage(uid);
    }

    @Override
    public long[] getMessageUids() {
        return this.folder.getMessageUids();
    }

    @Override
    public void expunge() throws FolderException {
        this.folder.expunge();
    }

    @Override
    public void expunge(IdRange[] idRanges) {
        this.folder.expunge(idRanges);
    }

    @Override
    public long[] search(SearchTerm searchTerm) {
        return this.folder.search(searchTerm);
    }

    @Override
    public long copyMessage(long uid, MailFolder toFolder) throws FolderException {
        return this.folder.copyMessage(uid, toFolder);
    }

    @Override
    public long moveMessage(long uid, MailFolder toFolder) throws FolderException {
        return this.folder.moveMessage(uid, toFolder);
    }

    @Override
    public void addListener(FolderListener listener) {
        this.folder.addListener(listener);
    }

    @Override
    public void removeListener(FolderListener listener) {
        this.folder.removeListener(listener);
    }

    @Override
    public void setFlags(Flags flags, boolean value, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        this.folder.setFlags(flags, value, uid, silentListener, addUid);
    }

    @Override
    public void replaceFlags(Flags flags, long uid, FolderListener silentListener, boolean addUid) throws FolderException {
        this.folder.replaceFlags(flags, uid, silentListener, addUid);
    }

    @Override
    public void deleteAllMessages() {
        this.folder.deleteAllMessages();
    }

    public boolean isSizeChanged() {
        return this.sizeChanged;
    }

    public void setSizeChanged(boolean sizeChanged) {
        this.sizeChanged = sizeChanged;
    }

    private UIDFolder unwrapUIDFolder() {
        if (this.folder instanceof UIDFolder) {
            return (UIDFolder)this.folder;
        }
        throw new IllegalStateException("No UIDFolder supported by " + this.folder.getClass());
    }

    public long getUIDValidity() throws MessagingException {
        return this.unwrapUIDFolder().getUIDValidity();
    }

    public Message getMessageByUID(long uid) throws MessagingException {
        return this.unwrapUIDFolder().getMessageByUID(uid);
    }

    public Message[] getMessagesByUID(long start, long end) throws MessagingException {
        return this.unwrapUIDFolder().getMessagesByUID(start, end);
    }

    public Message[] getMessagesByUID(long[] uids) throws MessagingException {
        return this.unwrapUIDFolder().getMessagesByUID(uids);
    }

    public long getUID(Message message) throws MessagingException {
        return this.unwrapUIDFolder().getUID(message);
    }

    @Override
    public long getUIDNext() {
        return this.folder.getUIDNext();
    }

    static final class FlagUpdate {
        private int msn;
        private Long uid;
        private Flags flags;

        public FlagUpdate(int msn, Long uid, Flags flags) {
            this.msn = msn;
            this.uid = uid;
            this.flags = flags;
        }

        public int getMsn() {
            return this.msn;
        }

        public Long getUid() {
            return this.uid;
        }

        public Flags getFlags() {
            return this.flags;
        }
    }
}

