/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.task.service.impl.util;

import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.task.service.TaskServiceConfiguration;
import org.flowable.task.service.impl.persistence.CountingTaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.variable.api.persistence.entity.VariableInstance;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.service.event.impl.FlowableVariableEventBuilder;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class CountingTaskUtil {
    public static void handleDeleteVariableInstanceEntityCount(VariableInstanceEntity variableInstance, boolean fireDeleteEvent, TaskServiceConfiguration taskServiceConfiguration) {
        CountingTaskEntity countingTaskEntity;
        if (variableInstance.getTaskId() != null && CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally(taskServiceConfiguration) && CountingTaskUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)taskServiceConfiguration.getTaskEntityManager().findById(variableInstance.getTaskId()), taskServiceConfiguration)) {
            countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() - 1);
        }
        FlowableEventDispatcher eventDispatcher = taskServiceConfiguration.getEventDispatcher();
        if (fireDeleteEvent && eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createEntityEvent((FlowableEngineEventType)FlowableEngineEventType.ENTITY_DELETED, (Object)variableInstance), taskServiceConfiguration.getEngineName());
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableVariableEventBuilder.createVariableEvent((FlowableEngineEventType)FlowableEngineEventType.VARIABLE_DELETED, (VariableInstance)variableInstance, null, (VariableType)variableInstance.getType()), taskServiceConfiguration.getEngineName());
        }
    }

    public static void handleInsertVariableInstanceEntityCount(VariableInstanceEntity variableInstance, TaskServiceConfiguration taskServiceConfiguration) {
        CountingTaskEntity countingTaskEntity;
        if (variableInstance.getTaskId() != null && CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally(taskServiceConfiguration) && CountingTaskUtil.isTaskRelatedEntityCountEnabled(countingTaskEntity = (CountingTaskEntity)taskServiceConfiguration.getTaskEntityManager().findById(variableInstance.getTaskId()), taskServiceConfiguration)) {
            countingTaskEntity.setVariableCount(countingTaskEntity.getVariableCount() + 1);
        }
    }

    public static boolean isTaskRelatedEntityCountEnabledGlobally(TaskServiceConfiguration taskServiceConfiguration) {
        if (taskServiceConfiguration == null) {
            return false;
        }
        return taskServiceConfiguration.isEnableTaskRelationshipCounts();
    }

    public static boolean isTaskRelatedEntityCountEnabled(TaskEntity taskEntity, TaskServiceConfiguration taskServiceConfiguration) {
        if (taskEntity instanceof CountingTaskEntity) {
            return CountingTaskUtil.isTaskRelatedEntityCountEnabled((CountingTaskEntity)((Object)taskEntity), taskServiceConfiguration);
        }
        return false;
    }

    public static boolean isTaskRelatedEntityCountEnabled(CountingTaskEntity taskEntity, TaskServiceConfiguration taskServiceConfiguration) {
        return CountingTaskUtil.isTaskRelatedEntityCountEnabledGlobally(taskServiceConfiguration) && taskEntity.isCountEnabled();
    }
}

