/*
 * Decompiled with CFR 0.152.
 */
package org.hjson;

import java.io.IOException;
import java.io.Writer;
import java.util.regex.Matcher;
import org.hjson.HjsonWriter;
import org.hjson.JsonArray;
import org.hjson.JsonObject;
import org.hjson.JsonValue;

class JsonWriter {
    boolean format;

    public JsonWriter(boolean format) {
        this.format = format;
    }

    void nl(Writer tw, int level) throws IOException {
        if (this.format) {
            tw.write(JsonValue.eol);
            for (int i = 0; i < level; ++i) {
                tw.write("  ");
            }
        }
    }

    public void save(JsonValue value, Writer tw, int level) throws IOException {
        boolean following = false;
        switch (value.getType()) {
            case OBJECT: {
                JsonObject obj = value.asObject();
                tw.write(123);
                for (JsonObject.Member pair : obj) {
                    if (following) {
                        tw.write(",");
                    }
                    this.nl(tw, level + 1);
                    tw.write(34);
                    tw.write(JsonWriter.escapeString(pair.getName()));
                    tw.write("\":");
                    JsonValue v = pair.getValue();
                    if (this.format) {
                        tw.write(" ");
                    }
                    if (v == null) {
                        tw.write("null");
                    } else {
                        this.save(v, tw, level + 1);
                    }
                    following = true;
                }
                if (following) {
                    this.nl(tw, level);
                }
                tw.write(125);
                break;
            }
            case ARRAY: {
                JsonArray arr = value.asArray();
                int n = arr.size();
                tw.write(91);
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        tw.write(",");
                    }
                    JsonValue v = arr.get(i);
                    this.nl(tw, level + 1);
                    this.save(arr.get(i), tw, level + 1);
                }
                if (n > 0) {
                    this.nl(tw, level);
                }
                tw.write(93);
                break;
            }
            case BOOLEAN: {
                tw.write(value.isTrue() ? "true" : "false");
                break;
            }
            case STRING: {
                tw.write(34);
                tw.write(JsonWriter.escapeString(value.asString()));
                tw.write(34);
                break;
            }
            default: {
                tw.write(value.toString());
            }
        }
    }

    static String escapeString(String src) {
        if (src == null) {
            return null;
        }
        int i = 0;
        StringBuilder sb = new StringBuilder();
        Matcher m = HjsonWriter.needsEscape.matcher(src);
        while (m.find()) {
            sb.append(src, i, m.start()).append(JsonWriter.getEscapedChar(m.group().charAt(0)));
            i = m.end();
        }
        if (i < 1) {
            return src;
        }
        sb.append(src, i, src.length());
        return sb.toString();
    }

    private static String getEscapedChar(char c) {
        switch (c) {
            case '\"': {
                return "\\\"";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\f': {
                return "\\f";
            }
            case '\b': {
                return "\\b";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return "\\u" + String.format("%04x", c);
    }
}

