/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.OAuth20GrantTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseModeTypes;
import org.apereo.cas.support.oauth.OAuth20ResponseTypes;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface OAuth20RequestParameterResolver {
    public static final String BEAN_NAME = "oauthRequestParameterResolver";
    public static final Logger LOGGER = LoggerFactory.getLogger(OAuth20RequestParameterResolver.class);

    public static boolean isAuthorizedGrantTypeForService(String grantType, OAuthRegisteredService registeredService) {
        return OAuth20RequestParameterResolver.isAuthorizedGrantTypeForService(grantType, registeredService, false);
    }

    public static boolean isAuthorizedGrantTypeForService(String grantType, OAuthRegisteredService registeredService, boolean rejectUndefined) {
        if (registeredService.getSupportedGrantTypes() != null && !registeredService.getSupportedGrantTypes().isEmpty()) {
            LOGGER.debug("Checking grant type [{}] against supported grant types [{}]", (Object)grantType, (Object)registeredService.getSupportedGrantTypes());
            return registeredService.getSupportedGrantTypes().stream().anyMatch(s -> s.equalsIgnoreCase(grantType));
        }
        LOGGER.warn("Registered service [{}] does not define any authorized/supported grant types. It is STRONGLY recommended that you authorize and assign grant types to the service definition. While just a warning for now, this behavior will be enforced by CAS in future versions.", (Object)registeredService.getName());
        return !rejectUndefined;
    }

    public boolean isAuthorizedGrantTypeForService(WebContext var1, OAuthRegisteredService var2);

    public OAuth20ResponseTypes resolveResponseType(WebContext var1);

    public OAuth20GrantTypes resolveGrantType(WebContext var1);

    public OAuth20ResponseModeTypes resolveResponseModeType(WebContext var1);

    public <T> T resolveJwtRequestParameter(String var1, RegisteredService var2, String var3, Class<T> var4) throws Exception;

    public <T> T resolveJwtRequestParameter(WebContext var1, String var2, String var3, Class<T> var4);

    public Map<String, Set<String>> resolveRequestParameters(Collection<String> var1, WebContext var2);

    public Set<String> resolveRequestParameters(WebContext var1, String var2);

    public Optional<String> resolveRequestParameter(WebContext var1, String var2);

    public <T> Optional<T> resolveRequestParameter(WebContext var1, String var2, Class<T> var3);

    public Collection<String> resolveRequestedScopes(WebContext var1);

    public boolean isAuthorizedResponseTypeForService(WebContext var1, OAuthRegisteredService var2);

    public Pair<String, String> resolveClientIdAndClientSecret(CallContext var1);

    public Set<String> resolveRequestScopes(WebContext var1);

    public Map<String, Map<String, Object>> resolveRequestClaims(WebContext var1) throws Exception;

    public Set<String> resolveUserInfoRequestClaims(WebContext var1) throws Exception;

    public Set<String> resolveRequestedPromptValues(WebContext var1);

    public Set<String> resolveSupportedPromptValues(String var1);

    default public Set<String> resolveSupportedPromptValues(WebContext context) {
        return this.resolveSupportedPromptValues(context.getFullRequestURL());
    }

    public boolean isParameterOnQueryString(WebContext var1, String var2);
}

