/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;

public class SpiOperationLoggingUtil {
    public static final Log.Level LOG_LEVEL = Log.Level.OK;

    public static void logOpEntry(Log opLog, ConnectorOperationalContext opContext, Class<?> opClass, String methodName, Object ... parameters) {
        if (!opLog.isLoggable(LOG_LEVEL)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SpiOperationLoggingUtil.appendInstanceName(sb, opContext);
        sb.append("Enter: ").append(methodName).append("(");
        for (int i = 0; i < parameters.length; ++i) {
            sb.append(parameters[i]);
            if (i >= parameters.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        opLog.log(opClass, methodName, LOG_LEVEL, sb.toString(), null);
    }

    public static void logOpExit(Log opLog, ConnectorOperationalContext opContext, Class<?> opClass, String methodName, Object returnValue) {
        if (!opLog.isLoggable(LOG_LEVEL)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SpiOperationLoggingUtil.appendInstanceName(sb, opContext);
        sb.append("Return: ").append(returnValue);
        opLog.log(opClass, methodName, LOG_LEVEL, sb.toString(), null);
    }

    public static void logOpExit(Log opLog, ConnectorOperationalContext opContext, Class<?> opClass, String methodName) {
        if (!opLog.isLoggable(LOG_LEVEL)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SpiOperationLoggingUtil.appendInstanceName(sb, opContext);
        sb.append("Return");
        opLog.log(opClass, methodName, LOG_LEVEL, sb.toString(), null);
    }

    public static void logOpException(Log opLog, ConnectorOperationalContext opContext, Class<?> opClass, String methodName, RuntimeException e) {
        if (!opLog.isLoggable(LOG_LEVEL)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        SpiOperationLoggingUtil.appendInstanceName(sb, opContext);
        sb.append("Exception: ");
        opLog.log(opClass, methodName, LOG_LEVEL, sb.toString(), (Throwable)e);
    }

    private static void appendInstanceName(StringBuilder sb, ConnectorOperationalContext opContext) {
        if (opContext == null) {
            return;
        }
        if (opContext.getInstanceName() != null) {
            sb.append("instance='").append(opContext.getInstanceName()).append("' ");
        }
    }
}

