/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.mvc.view;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.SourceVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.binding.convert.ConversionExecutor;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.expression.EvaluationException;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.ParserContext;
import org.springframework.binding.expression.beanwrapper.BeanWrapperExpressionParser;
import org.springframework.binding.expression.support.SimpleParserContext;
import org.springframework.binding.expression.support.StaticExpression;
import org.springframework.binding.mapping.MappingResult;
import org.springframework.binding.mapping.MappingResults;
import org.springframework.binding.mapping.MappingResultsCriteria;
import org.springframework.binding.mapping.impl.DefaultMapper;
import org.springframework.binding.mapping.impl.DefaultMapping;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageResolver;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.validation.MessageCodesResolver;
import org.springframework.validation.Validator;
import org.springframework.web.util.WebUtils;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.TransitionDefinition;
import org.springframework.webflow.engine.builder.BinderConfiguration;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowExecutionKey;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.View;
import org.springframework.webflow.mvc.view.BindingModel;
import org.springframework.webflow.mvc.view.ViewActionStateHolder;
import org.springframework.webflow.validation.BeanValidationHintResolver;
import org.springframework.webflow.validation.ValidationHelper;
import org.springframework.webflow.validation.ValidationHintResolver;

public abstract class AbstractMvcView
implements View {
    private static final Log logger = LogFactory.getLog(AbstractMvcView.class);
    private static final MappingResultsCriteria PROPERTY_NOT_FOUND_ERROR = new PropertyNotFoundError();
    private static final MappingResultsCriteria MAPPING_ERROR = new MappingError();
    private org.springframework.web.servlet.View view;
    private RequestContext requestContext;
    private ExpressionParser expressionParser;
    private final ExpressionParser emptyValueExpressionParser = new BeanWrapperExpressionParser();
    private ConversionService conversionService;
    private Validator validator;
    private String fieldMarkerPrefix = "_";
    private String eventIdParameterName = "_eventId";
    private String eventId;
    private MappingResults mappingResults;
    private BinderConfiguration binderConfiguration;
    private MessageCodesResolver messageCodesResolver;
    private boolean userEventProcessed;
    private ValidationHintResolver validationHintResolver = new BeanValidationHintResolver();

    public AbstractMvcView(org.springframework.web.servlet.View view, RequestContext requestContext) {
        this.view = view;
        this.requestContext = requestContext;
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        this.expressionParser = expressionParser;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    public void setValidationHintResolver(ValidationHintResolver validationHintResolver) {
        if (validationHintResolver != null) {
            this.validationHintResolver = validationHintResolver;
        }
    }

    public void setBinderConfiguration(BinderConfiguration binderConfiguration) {
        this.binderConfiguration = binderConfiguration;
    }

    public void setMessageCodesResolver(MessageCodesResolver messageCodesResolver) {
        this.messageCodesResolver = messageCodesResolver;
    }

    public void setFieldMarkerPrefix(String fieldMarkerPrefix) {
        this.fieldMarkerPrefix = fieldMarkerPrefix;
    }

    public void setEventIdParameterName(String eventIdParameterName) {
        this.eventIdParameterName = eventIdParameterName;
    }

    @Override
    public void render() throws IOException {
        HashMap<String, Object> model = new HashMap<String, Object>();
        model.putAll(this.flowScopes());
        this.exposeBindingModel(model);
        model.put("flowRequestContext", this.requestContext);
        FlowExecutionKey key = this.requestContext.getFlowExecutionContext().getKey();
        if (key != null) {
            model.put("flowExecutionKey", this.requestContext.getFlowExecutionContext().getKey().toString());
            model.put("flowExecutionUrl", this.requestContext.getFlowExecutionUrl());
        }
        model.put("currentUser", this.requestContext.getExternalContext().getCurrentUser());
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Rendering MVC [" + this.view + "] with model map [" + model + "]"));
            }
            this.doRender(model);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            IllegalStateException ise = new IllegalStateException("Exception occurred rendering view " + this.view);
            ise.initCause(e);
            throw ise;
        }
    }

    @Override
    public boolean userEventQueued() {
        return !this.userEventProcessed && this.getEventId() != null;
    }

    @Override
    public void processUserEvent() {
        Object model;
        String eventId = this.getEventId();
        if (eventId == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Processing user event '" + eventId + "'"));
        }
        if ((model = this.getModelObject()) != null) {
            TransitionDefinition transition;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved model " + model));
            }
            if (this.shouldBind(model, transition = this.requestContext.getMatchingTransition(eventId))) {
                this.mappingResults = this.bind(model);
                if (this.hasErrors(this.mappingResults)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)"Model binding resulted in errors; adding error messages to context");
                    }
                    this.addErrorMessages(this.mappingResults);
                }
                if (this.shouldValidate(model, transition)) {
                    this.validate(model, transition);
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"No model to bind to; done processing user event");
        }
        this.userEventProcessed = true;
    }

    @Override
    public Serializable getUserEventState() {
        return new ViewActionStateHolder(this.eventId, this.userEventProcessed, this.mappingResults);
    }

    @Override
    public boolean hasFlowEvent() {
        return this.userEventProcessed && !this.requestContext.getMessageContext().hasErrorMessages();
    }

    @Override
    public Event getFlowEvent() {
        if (!this.hasFlowEvent()) {
            return null;
        }
        return new Event(this, this.getEventId(), this.requestContext.getRequestParameters().asAttributeMap());
    }

    @Override
    public void saveState() {
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("view", (Object)this.view).toString();
    }

    protected RequestContext getRequestContext() {
        return this.requestContext;
    }

    protected org.springframework.web.servlet.View getView() {
        return this.view;
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    protected abstract void doRender(Map<String, ?> var1) throws Exception;

    protected String getEventId() {
        if (this.eventId == null) {
            this.eventId = this.determineEventId(this.requestContext);
        }
        return this.eventId;
    }

    protected boolean shouldBind(Object model, TransitionDefinition transition) {
        if (transition == null) {
            return true;
        }
        return transition.getAttributes().getBoolean("bind", true);
    }

    protected MappingResults getMappingResults() {
        return this.mappingResults;
    }

    protected BinderConfiguration getBinderConfiguration() {
        return this.binderConfiguration;
    }

    protected ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    protected String getFieldMarkerPrefix() {
        return this.fieldMarkerPrefix;
    }

    protected String determineEventId(RequestContext context) {
        return WebUtils.findParameterValue((Map)context.getRequestParameters().asMap(), (String)this.eventIdParameterName);
    }

    protected MappingResults bind(Object model) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Binding to model");
        }
        DefaultMapper mapper = new DefaultMapper();
        ParameterMap requestParameters = this.requestContext.getRequestParameters();
        if (this.binderConfiguration != null) {
            this.addModelBindings(mapper, requestParameters.asMap().keySet(), model);
        } else {
            this.addDefaultMappings(mapper, requestParameters.asMap().keySet(), model);
        }
        return mapper.map((Object)requestParameters, model);
    }

    protected void addModelBindings(DefaultMapper mapper, Set<String> parameterNames, Object model) {
        for (BinderConfiguration.Binding binding : this.binderConfiguration.getBindings()) {
            String parameterName = binding.getProperty();
            if (parameterNames.contains(parameterName)) {
                this.addMapping(mapper, binding, model);
                continue;
            }
            if (this.fieldMarkerPrefix == null || !parameterNames.contains(this.fieldMarkerPrefix + parameterName)) continue;
            this.addEmptyValueMapping(mapper, parameterName, model);
        }
    }

    protected void addMapping(DefaultMapper mapper, BinderConfiguration.Binding binding, Object model) {
        RequestParameterExpression source = new RequestParameterExpression(binding.getProperty());
        SimpleParserContext parserContext = new SimpleParserContext(model.getClass());
        Expression target = this.expressionParser.parseExpression(binding.getProperty(), (ParserContext)parserContext);
        DefaultMapping mapping = new DefaultMapping((Expression)source, target);
        mapping.setRequired(binding.getRequired());
        if (binding.getConverter() != null) {
            Assert.notNull((Object)this.conversionService, (String)"A ConversionService must be configured to use resolve custom converters to use during binding");
            ConversionExecutor conversionExecutor = this.conversionService.getConversionExecutor(binding.getConverter(), String.class, target.getValueType(model));
            mapping.setTypeConverter(conversionExecutor);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Adding mapping for parameter '" + binding.getProperty() + "'"));
        }
        mapper.addMapping(mapping);
    }

    protected void addDefaultMappings(DefaultMapper mapper, Set<String> parameterNames, Object model) {
        for (String parameterName : parameterNames) {
            if (this.fieldMarkerPrefix != null && parameterName.startsWith(this.fieldMarkerPrefix)) {
                String field = parameterName.substring(this.fieldMarkerPrefix.length());
                if (parameterNames.contains(field)) continue;
                this.addEmptyValueMapping(mapper, field, model);
                continue;
            }
            this.addDefaultMapping(mapper, parameterName, model);
        }
    }

    protected void addEmptyValueMapping(DefaultMapper mapper, String field, Object model) {
        SimpleParserContext parserContext = new SimpleParserContext(model.getClass());
        Expression target = this.emptyValueExpressionParser.parseExpression(field, (ParserContext)parserContext);
        try {
            Class propertyType = target.getValueType(model);
            StaticExpression source = new StaticExpression(this.getEmptyValue(propertyType));
            DefaultMapping mapping = new DefaultMapping((Expression)source, target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding empty value mapping for parameter '" + field + "'"));
            }
            mapper.addMapping(mapping);
        }
        catch (EvaluationException evaluationException) {
            // empty catch block
        }
    }

    protected void addDefaultMapping(DefaultMapper mapper, String parameter, Object model) {
        RequestParameterExpression source = new RequestParameterExpression(parameter);
        SimpleParserContext parserContext = new SimpleParserContext(model.getClass());
        if (this.expressionParser instanceof BeanWrapperExpressionParser || this.checkModelProperty(parameter, model)) {
            Expression target = this.expressionParser.parseExpression(parameter, (ParserContext)parserContext);
            DefaultMapping mapping = new DefaultMapping((Expression)source, target);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Adding default mapping for parameter '" + parameter + "'"));
            }
            mapper.addMapping(mapping);
        }
    }

    private boolean checkModelProperty(String expression, Object model) {
        ArrayList<String> propertyNames = new ArrayList<String>();
        while (true) {
            int index;
            String nestedProperty = (index = PropertyAccessorUtils.getFirstNestedPropertySeparatorIndex((String)expression)) != -1 ? expression.substring(0, index) : expression;
            nestedProperty = PropertyAccessorUtils.getPropertyName((String)nestedProperty);
            propertyNames.add(nestedProperty);
            if (index == -1) break;
            if (expression.length() == index + 1) {
                return false;
            }
            expression = expression.substring(index + 1);
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(model);
        if (!beanWrapper.isReadableProperty((String)propertyNames.get(0))) {
            return false;
        }
        for (String propertyName : propertyNames) {
            if (SourceVersion.isName(propertyName)) continue;
            return false;
        }
        return true;
    }

    void restoreState(ViewActionStateHolder stateHolder) {
        this.eventId = stateHolder.getEventId();
        this.userEventProcessed = stateHolder.getUserEventProcessed();
        this.mappingResults = stateHolder.getMappingResults();
    }

    protected boolean shouldValidate(Object model, TransitionDefinition transition) {
        Boolean validateAttribute = this.getValidateAttribute(transition);
        if (validateAttribute != null) {
            return validateAttribute;
        }
        AttributeMap<Object> flowExecutionAttributes = this.requestContext.getFlowExecutionContext().getAttributes();
        Boolean validateOnBindingErrors = flowExecutionAttributes.getBoolean("validateOnBindingErrors");
        return validateOnBindingErrors == null || validateOnBindingErrors != false || !this.mappingResults.hasErrorResults();
    }

    private Map<String, Object> flowScopes() {
        if (this.requestContext.getCurrentState().isViewState()) {
            return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getViewScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
        }
        return this.requestContext.getConversationScope().union(this.requestContext.getFlowScope()).union(this.requestContext.getFlashScope()).union(this.requestContext.getRequestScope()).asMap();
    }

    private void exposeBindingModel(Map<String, Object> model) {
        Object modelObject = this.getModelObject();
        if (modelObject != null) {
            BindingModel bindingModel = new BindingModel(this.getModelExpression().getExpressionString(), modelObject, this.expressionParser, this.conversionService, this.requestContext.getMessageContext());
            bindingModel.setBinderConfiguration(this.binderConfiguration);
            bindingModel.setMappingResults(this.mappingResults);
            model.put(BindingResult.MODEL_KEY_PREFIX + this.getModelExpression().getExpressionString(), (Object)bindingModel);
        }
    }

    private Object getModelObject() {
        Expression model = this.getModelExpression();
        if (model != null) {
            try {
                return model.getValue((Object)this.requestContext);
            }
            catch (EvaluationException e) {
                return null;
            }
        }
        return null;
    }

    private Expression getModelExpression() {
        return (Expression)this.requestContext.getCurrentState().getAttributes().get("model");
    }

    private Object getEmptyValue(Class<?> fieldType) {
        if (fieldType != null && Boolean.TYPE.equals(fieldType) || Boolean.class.equals(fieldType)) {
            return false;
        }
        if (fieldType != null && fieldType.isArray()) {
            return Array.newInstance(fieldType.getComponentType(), 0);
        }
        return null;
    }

    private boolean hasErrors(MappingResults results) {
        return results.hasErrorResults() && !this.onlyPropertyNotFoundErrorsPresent(results);
    }

    private boolean onlyPropertyNotFoundErrorsPresent(MappingResults results) {
        return results.getResults(PROPERTY_NOT_FOUND_ERROR).size() == this.mappingResults.getErrorResults().size();
    }

    private void addErrorMessages(MappingResults results) {
        List errors = results.getResults(MAPPING_ERROR);
        for (MappingResult error : errors) {
            this.requestContext.getMessageContext().addMessage(this.createMessageResolver(error));
        }
    }

    protected MessageResolver createMessageResolver(MappingResult error) {
        String model = this.getModelExpression().getExpressionString();
        String field = error.getMapping().getTargetExpression().getExpressionString();
        Class fieldType = error.getMapping().getTargetExpression().getValueType(this.getModelObject());
        String[] messageCodes = this.messageCodesResolver.resolveMessageCodes(error.getCode(), model, field, fieldType);
        return new MessageBuilder().error().source((Object)field).codes(messageCodes).resolvableArg((Object)field).defaultText(error.getCode() + " on " + field).build();
    }

    private Boolean getValidateAttribute(TransitionDefinition transition) {
        if (transition != null) {
            return transition.getAttributes().getBoolean("validate");
        }
        return null;
    }

    private void validate(Object model, TransitionDefinition transition) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Validating model");
        }
        ValidationHelper helper = new ValidationHelper(model, this.requestContext, this.eventId, this.getModelExpression().getExpressionString(), this.expressionParser, this.messageCodesResolver, this.mappingResults, this.validationHintResolver);
        helper.setValidator(this.validator);
        helper.validate();
    }

    private static class RequestParameterExpression
    implements Expression {
        private String parameterName;

        public RequestParameterExpression(String parameterName) {
            this.parameterName = parameterName;
        }

        public String getExpressionString() {
            return this.parameterName;
        }

        public Object getValue(Object context) throws EvaluationException {
            ParameterMap parameters = (ParameterMap)context;
            return parameters.asMap().get(this.parameterName);
        }

        public Class<?> getValueType(Object context) {
            return String.class;
        }

        public void setValue(Object context, Object value) throws EvaluationException {
            throw new UnsupportedOperationException("Setting request parameters is not allowed");
        }

        public String toString() {
            return "parameter:'" + this.parameterName + "'";
        }
    }

    private static class PropertyNotFoundError
    implements MappingResultsCriteria {
        private PropertyNotFoundError() {
        }

        public boolean test(MappingResult result) {
            return result.isError() && "propertyNotFound".equals(result.getCode());
        }
    }

    private static class MappingError
    implements MappingResultsCriteria {
        private MappingError() {
        }

        public boolean test(MappingResult result) {
            return result.isError() && !PROPERTY_NOT_FOUND_ERROR.test(result);
        }
    }
}

