/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.kendo.ui.form.datetime.local;

import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.convert.IConverter;
import org.wicketstuff.jquery.core.IJQueryWidget;
import org.wicketstuff.jquery.core.JQueryBehavior;
import org.wicketstuff.jquery.core.Options;
import org.wicketstuff.jquery.core.utils.LocaleUtils;
import org.wicketstuff.kendo.ui.KendoUIBehavior;
import org.wicketstuff.kendo.ui.utils.KendoDateTimeUtils;

public abstract class LocalTextField<T>
extends TextField<T>
implements AbstractTextComponent.ITextFormatProvider,
IJQueryWidget {
    private static final long serialVersionUID = 1L;
    private final Locale locale;
    private final String pattern;
    private final IConverter<T> converter;
    protected final Options options;

    public LocalTextField(String id, IModel<T> model, Locale locale, String pattern, Options options, Class<T> type, IConverter<T> converter) {
        super(id, model, type);
        this.locale = locale;
        this.pattern = pattern;
        this.options = options;
        this.converter = converter;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Behavior[]{IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this)});
    }

    public void onConfigure(JQueryBehavior behavior) {
        if (behavior.getOption("culture") == null) {
            behavior.setOption("culture", (Object)Options.asString((String)LocaleUtils.getLangageCode((Locale)this.getLocale())));
        }
        if (behavior.getOption("format") == null) {
            behavior.setOption("format", (Object)Options.asString((String)KendoDateTimeUtils.toPattern(this.getTextFormat())));
        }
    }

    public void onBeforeRender(JQueryBehavior behavior) {
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public final String getTextFormat() {
        return this.pattern;
    }

    public <C> IConverter<C> getConverter(Class<C> type) {
        if (this.getType().isAssignableFrom(type)) {
            return this.converter;
        }
        return super.getConverter(type);
    }

    public String getModelObjectAsString() {
        Object date = this.getModelObject();
        if (date != null) {
            return this.converter.convertToString(date, this.getLocale());
        }
        return "";
    }

    protected abstract String getMethod();

    public String getInput() {
        String input = super.getInput();
        if (input != null) {
            return KendoDateTimeUtils.convert(input);
        }
        return null;
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new KendoUIBehavior(selector, this.getMethod(), this.options);
    }
}

