/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.wicket.ws;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.wicket.Application;
import org.apache.wicket.protocol.ws.WebSocketSettings;
import org.apache.wicket.protocol.ws.api.IWebSocketConnection;
import org.apache.wicket.protocol.ws.api.WebSocketBehavior;
import org.apache.wicket.protocol.ws.api.WebSocketRequestHandler;
import org.apache.wicket.protocol.ws.api.message.ConnectedMessage;
import org.apache.wicket.protocol.ws.api.message.IWebSocketPushMessage;
import org.apache.wicket.protocol.ws.api.registry.IKey;

public abstract class RefreshWebSocketBehavior
extends WebSocketBehavior {
    private static final long serialVersionUID = 5636572627689425575L;
    protected final Mutable<Pair<String, IKey>> websocketInfo = new MutableObject();
    protected final String nonce = UUID.randomUUID().toString();

    protected void onConnect(ConnectedMessage message) {
        this.websocketInfo.setValue((Object)Pair.of((Object)message.getSessionId(), (Object)message.getKey()));
    }

    protected abstract void onTimer(WebSocketRequestHandler var1);

    protected void onPush(WebSocketRequestHandler handler, IWebSocketPushMessage message) {
        RefreshMessage refreshMessage;
        if (message instanceof RefreshMessage && this.nonce.equals((refreshMessage = (RefreshMessage)message).nonce())) {
            this.onTimer(handler);
        }
    }

    public RefreshWebSocketBehavior schedule(long period, TimeUnit unit) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, Thread.ofVirtual().factory());
        executor.scheduleAtFixedRate(() -> {
            if (this.websocketInfo.get() == null) {
                return;
            }
            Application application = Application.get((String)"wicket-filter");
            IWebSocketConnection wsConnection = WebSocketSettings.Holder.get((Application)application).getConnectionRegistry().getConnection(application, (String)((Pair)this.websocketInfo.get()).getLeft(), (IKey)((Pair)this.websocketInfo.get()).getRight());
            Optional.ofNullable(wsConnection).filter(IWebSocketConnection::isOpen).ifPresentOrElse(wsc -> wsc.sendMessage((IWebSocketPushMessage)new RefreshMessage(this.nonce)), () -> executor.shutdownNow());
        }, 0L, period, unit);
        return this;
    }

    private record RefreshMessage(String nonce) implements IWebSocketPushMessage
    {
    }
}

