/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldup.sync;

import java.util.Base64;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.tirasa.connid.bundles.ldup.LdUpUtils;
import net.tirasa.connid.bundles.ldup.sync.AbstractLdUpSyncOp;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchScope;
import org.ldaptive.SingleConnectionFactory;
import org.ldaptive.control.SyncDoneControl;
import org.ldaptive.control.util.CookieManager;
import org.ldaptive.control.util.DefaultCookieManager;
import org.ldaptive.control.util.SyncReplClient;

public class LdUpSyncOp
extends AbstractLdUpSyncOp
implements SyncOp {
    protected static final Log LOG = Log.getLog(LdUpSyncOp.class);

    public LdUpSyncOp(LdUpUtils ldUpUtils) {
        super(ldUpUtils);
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        AtomicReference latest = new AtomicReference();
        SingleConnectionFactory scf = new SingleConnectionFactory(this.ldUpUtils.getConnectionConfig());
        SyncReplClient client = new SyncReplClient((ConnectionFactory)scf, false);
        try {
            scf.initialize();
            client.setOnResult(result -> {
                LOG.ok("SyncRepl result received: {0}", new Object[]{result});
                SyncDoneControl syncDoneControl = (SyncDoneControl)result.getControl("1.3.6.1.4.1.4203.1.9.1.3");
                latest.set(Base64.getEncoder().encodeToString(syncDoneControl.getCookie()));
            });
            client.setOnException(e -> LOG.error((Throwable)e, "SyncRepl exception thrown", new Object[0]));
            client.send((SearchRequest)SearchRequest.builder().dn(this.ldUpUtils.getConfiguration().getBaseDn()).scope(SearchScope.SUBTREE).filter("objectClass=" + this.ldUpUtils.ldapObjectClass(objectClass)).build(), (CookieManager)new DefaultCookieManager()).await();
        }
        catch (LdapException e2) {
            throw new ConnectorException("While managing SyncRepl events for " + objectClass, (Throwable)e2);
        }
        finally {
            client.close();
            scf.close();
        }
        return Optional.ofNullable((String)latest.get()).map(SyncToken::new).orElse(null);
    }

    public void sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        List<SyncDeltaBuilder> objects = this.dosync(objectClass, object -> new SyncDeltaBuilder().setDeltaType(SyncDeltaType.CREATE_OR_UPDATE).setObject(object.build()), object -> new SyncDeltaBuilder().setDeltaType(SyncDeltaType.DELETE).setObject(object.build()), (syncDelta, cookie) -> syncDelta.setToken(new SyncToken(cookie)), Optional.ofNullable(token).map(t -> Base64.getDecoder().decode(t.getValue().toString())).orElse(null), options);
        objects.forEach(object -> handler.handle(object.build()));
    }
}

