/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.openfga.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Locale;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.syncope.ext.openfga.client.ApiClient;
import org.apache.syncope.ext.openfga.client.model.ConsistencyPreference;
import org.apache.syncope.ext.openfga.client.model.ContextualTupleKeys;
import org.apache.syncope.ext.openfga.client.model.ExpandRequestTupleKey;

@JsonPropertyOrder(value={"tuple_key", "authorization_model_id", "consistency", "contextual_tuples"})
public class ExpandRequest {
    public static final String JSON_PROPERTY_TUPLE_KEY = "tuple_key";
    @Nonnull
    private ExpandRequestTupleKey tupleKey;
    public static final String JSON_PROPERTY_AUTHORIZATION_MODEL_ID = "authorization_model_id";
    @Nullable
    private String authorizationModelId;
    public static final String JSON_PROPERTY_CONSISTENCY = "consistency";
    @Nullable
    private ConsistencyPreference consistency = ConsistencyPreference.UNSPECIFIED;
    public static final String JSON_PROPERTY_CONTEXTUAL_TUPLES = "contextual_tuples";
    @Nullable
    private ContextualTupleKeys contextualTuples;

    public ExpandRequest tupleKey(@Nonnull ExpandRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
        return this;
    }

    @Nonnull
    @JsonProperty(value="tuple_key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public ExpandRequestTupleKey getTupleKey() {
        return this.tupleKey;
    }

    @JsonProperty(value="tuple_key", required=true)
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setTupleKey(@Nonnull ExpandRequestTupleKey tupleKey) {
        this.tupleKey = tupleKey;
    }

    public ExpandRequest authorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
        return this;
    }

    @Nullable
    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getAuthorizationModelId() {
        return this.authorizationModelId;
    }

    @JsonProperty(value="authorization_model_id", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setAuthorizationModelId(@Nullable String authorizationModelId) {
        this.authorizationModelId = authorizationModelId;
    }

    public ExpandRequest consistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
        return this;
    }

    @Nullable
    @JsonProperty(value="consistency", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ConsistencyPreference getConsistency() {
        return this.consistency;
    }

    @JsonProperty(value="consistency", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setConsistency(@Nullable ConsistencyPreference consistency) {
        this.consistency = consistency;
    }

    public ExpandRequest contextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
        return this;
    }

    @Nullable
    @JsonProperty(value="contextual_tuples", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ContextualTupleKeys getContextualTuples() {
        return this.contextualTuples;
    }

    @JsonProperty(value="contextual_tuples", required=false)
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setContextualTuples(@Nullable ContextualTupleKeys contextualTuples) {
        this.contextualTuples = contextualTuples;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExpandRequest expandRequest = (ExpandRequest)o;
        return Objects.equals(this.tupleKey, expandRequest.tupleKey) && Objects.equals(this.authorizationModelId, expandRequest.authorizationModelId) && Objects.equals((Object)this.consistency, (Object)expandRequest.consistency) && Objects.equals(this.contextualTuples, expandRequest.contextualTuples);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tupleKey, this.authorizationModelId, this.consistency, this.contextualTuples});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExpandRequest {\n");
        sb.append("    tupleKey: ").append(this.toIndentedString(this.tupleKey)).append("\n");
        sb.append("    authorizationModelId: ").append(this.toIndentedString(this.authorizationModelId)).append("\n");
        sb.append("    consistency: ").append(this.toIndentedString((Object)this.consistency)).append("\n");
        sb.append("    contextualTuples: ").append(this.toIndentedString(this.contextualTuples)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getTupleKey() != null) {
            joiner.add(this.getTupleKey().toUrlQueryString((String)prefix + JSON_PROPERTY_TUPLE_KEY + suffix));
        }
        if (this.getAuthorizationModelId() != null) {
            joiner.add(String.format(Locale.ROOT, "%sauthorization_model_id%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString(this.getAuthorizationModelId()))));
        }
        if (this.getConsistency() != null) {
            joiner.add(String.format(Locale.ROOT, "%sconsistency%s=%s", prefix, suffix, ApiClient.urlEncode(ApiClient.valueToString((Object)this.getConsistency()))));
        }
        if (this.getContextualTuples() != null) {
            joiner.add(this.getContextualTuples().toUrlQueryString((String)prefix + JSON_PROPERTY_CONTEXTUAL_TUPLES + suffix));
        }
        return joiner.toString();
    }
}

