/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.terracotta.common.struct.TimeBudget;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.lease.connection.BasicLeasedConnection;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionService;

public class LeasedConnectionServiceImpl
implements LeasedConnectionService {
    private static final String SCHEME = "terracotta";
    private static final String DEFAULT_LEASED_CONNECTION_TIMEOUT = "150000";

    @Override
    public boolean handlesURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    @Override
    public boolean handlesConnectionType(String connectionType) {
        return SCHEME.equals(connectionType);
    }

    @Override
    public LeasedConnection connect(URI uri, Properties properties) throws ConnectionException {
        Connection connection = ConnectionFactory.connect(uri, properties);
        return this.createLeasedConnection(properties, connection);
    }

    @Override
    public LeasedConnection connect(Iterable<InetSocketAddress> servers, Properties properties) throws ConnectionException {
        Connection connection = ConnectionFactory.connect(servers, properties);
        return this.createLeasedConnection(properties, connection);
    }

    private LeasedConnection createLeasedConnection(Properties properties, Connection connection) throws ConnectionException {
        TimeBudget timeBudget = LeasedConnectionServiceImpl.createTimeBudget(properties);
        return BasicLeasedConnection.create(connection, timeBudget);
    }

    private static TimeBudget createTimeBudget(Properties properties) {
        String timeoutString = properties.getProperty("connection.timeout", DEFAULT_LEASED_CONNECTION_TIMEOUT);
        long timeout = Long.parseLong(timeoutString);
        return new TimeBudget(timeout, TimeUnit.MILLISECONDS);
    }
}

