/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.instrumentation;

import java.util.Date;
import java.util.Map;
import org.apache.openjpa.datacache.CacheStatistics;
import org.apache.openjpa.datacache.CacheStatisticsSPI;
import org.apache.openjpa.datacache.DataCache;
import org.apache.openjpa.datacache.DataCacheManager;
import org.apache.openjpa.instrumentation.DataCacheInstrument;
import org.apache.openjpa.lib.instrumentation.AbstractInstrument;
import org.apache.openjpa.lib.instrumentation.InstrumentationLevel;

public abstract class AbstractDataCacheInstrument
extends AbstractInstrument
implements DataCacheInstrument {
    public static final long NO_STATS = -1L;
    private DataCacheManager _dcm = null;
    private DataCache _dc = null;
    private String _configID = null;
    private String _configRef = null;

    public void setDataCache(DataCache dc) {
        this._dc = dc;
    }

    public void setDataCacheManager(DataCacheManager dcm) {
        this._dcm = dcm;
    }

    public void setConfigId(String cid) {
        this._configID = cid;
    }

    public void setContextRef(String cref) {
        this._configRef = cref;
    }

    @Override
    public long getHitCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getHitCount();
        }
        return -1L;
    }

    @Override
    public long getReadCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getReadCount();
        }
        return -1L;
    }

    @Override
    public long getTotalHitCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalHitCount();
        }
        return -1L;
    }

    @Override
    public long getTotalReadCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalReadCount();
        }
        return -1L;
    }

    @Override
    public long getTotalWriteCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalWriteCount();
        }
        return -1L;
    }

    @Override
    public long getWriteCount() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getWriteCount();
        }
        return -1L;
    }

    @Override
    public void reset() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            stats.reset();
        }
    }

    @Override
    public Date sinceDate() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.since();
        }
        return null;
    }

    @Override
    public Date startDate() {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.start();
        }
        return null;
    }

    public String getConfigId() {
        return this._configID;
    }

    public String getContextRef() {
        return this._configRef;
    }

    @Override
    public String getCacheName() {
        if (this._dc != null) {
            return this._dc.getName();
        }
        return null;
    }

    private CacheStatistics getStatistics() {
        if (this._dc != null) {
            return this._dc.getStatistics();
        }
        return null;
    }

    @Override
    public long getWriteCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getWriteCount(c);
        }
        return -1L;
    }

    @Override
    public long getTotalWriteCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalWriteCount(c);
        }
        return -1L;
    }

    @Override
    public long getTotalReadCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalReadCount(c);
        }
        return -1L;
    }

    @Override
    public long getTotalHitCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getTotalHitCount(c);
        }
        return -1L;
    }

    @Override
    public long getReadCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getReadCount(c);
        }
        return -1L;
    }

    @Override
    public long getHitCount(String c) {
        CacheStatistics stats = this.getStatistics();
        if (stats != null) {
            return stats.getHitCount(c);
        }
        return -1L;
    }

    public InstrumentationLevel getLevel() {
        return InstrumentationLevel.FACTORY;
    }

    @Override
    public void cache(String className, boolean enable) {
        if (enable) {
            this._dcm.startCaching(className);
        } else {
            this._dcm.stopCaching(className);
        }
    }

    @Override
    public Map<String, Boolean> listKnownTypes() {
        return this._dcm.listKnownTypes();
    }

    @Override
    public void collectStatistics(boolean enable) {
        CacheStatisticsSPI stats = (CacheStatisticsSPI)this._dc.getStatistics();
        if (enable) {
            stats.enable();
        } else {
            stats.disable();
        }
    }

    @Override
    public Boolean getStatisticsEnabled() {
        CacheStatisticsSPI stats = (CacheStatisticsSPI)this._dc.getStatistics();
        return stats.isEnabled();
    }

    @Override
    public Map<String, long[]> getCacheStatistics() {
        return this._dc.getStatistics().toMap();
    }

    @Override
    public void clear() {
        this._dc.clear();
    }
}

