/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.consent;

import javax.servlet.http.HttpServletRequest;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.MultifactorAuthenticationContextValidator;
import org.apereo.cas.authentication.MultifactorAuthenticationTriggerSelectionStrategy;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.consent.ConsentActivationStrategy;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.support.saml.web.idp.web.SamlIdPSingleSignOnParticipationStrategy;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.web.flow.SingleSignOnParticipationRequest;

public class SamlIdPConsentSingleSignOnParticipationStrategy
extends SamlIdPSingleSignOnParticipationStrategy {
    private final ConsentActivationStrategy consentActivationStrategy;

    public SamlIdPConsentSingleSignOnParticipationStrategy(ServicesManager servicesManager, TicketRegistrySupport ticketRegistrySupport, AuthenticationServiceSelectionPlan serviceSelectionStrategy, ConsentActivationStrategy consentActivationStrategy, MultifactorAuthenticationContextValidator authenticationContextValidator, MultifactorAuthenticationTriggerSelectionStrategy triggerSelectionStrategy) {
        super(servicesManager, ticketRegistrySupport, serviceSelectionStrategy, authenticationContextValidator, triggerSelectionStrategy);
        this.consentActivationStrategy = consentActivationStrategy;
    }

    @Override
    public boolean isParticipating(SingleSignOnParticipationRequest ssoRequest) {
        Authentication authentication;
        RegisteredService registeredService;
        Service service = (Service)ssoRequest.getAttributeValue(Service.class.getName(), Service.class);
        boolean consentRequired = this.consentActivationStrategy.isConsentRequired(service, registeredService = (RegisteredService)ssoRequest.getAttributeValue(RegisteredService.class.getName(), RegisteredService.class), authentication = (Authentication)ssoRequest.getAttributeValue(Authentication.class.getName(), Authentication.class), (HttpServletRequest)ssoRequest.getHttpServletRequest().orElse(null));
        return !consentRequired && super.isParticipating(ssoRequest);
    }
}

