/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.client;

import java.util.Optional;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;
import org.pac4j.oauth.client.OAuth20Client;
import org.pac4j.oauth.profile.paypal.PayPalProfileDefinition;
import org.pac4j.scribe.builder.api.PayPalApi20;

public class PayPalClient
extends OAuth20Client {
    public static final String DEFAULT_SCOPE = "openid profile email address";

    public PayPalClient() {
        this.setScope(DEFAULT_SCOPE);
    }

    public PayPalClient(String key, String secret) {
        this.setScope(DEFAULT_SCOPE);
        this.setKey(key);
        this.setSecret(secret);
    }

    @Override
    protected void internalInit(boolean forceReinit) {
        CommonHelper.assertNotBlank((String)"scope", (String)this.getConfiguration().getScope());
        this.configuration.setApi((Object)new PayPalApi20());
        this.configuration.setProfileDefinition(new PayPalProfileDefinition());
        this.configuration.setTokenAsHeader(true);
        this.defaultLogoutActionBuilder((ctx, session, profile, targetUrl) -> Optional.of(HttpActionHelper.buildRedirectUrlAction((WebContext)ctx, (String)"https://www.paypal.com/myaccount/logout")));
        super.internalInit(forceReinit);
    }

    public String getScope() {
        return this.getConfiguration().getScope();
    }

    public void setScope(String scope) {
        this.getConfiguration().setScope(scope);
    }
}

