/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.FieldProperty;
import com.fasterxml.jackson.databind.deser.impl.MethodProperty;
import com.fasterxml.jackson.databind.deser.std.StdValueInstantiator;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.module.afterburner.deser.BeanPropertyMutator;
import com.fasterxml.jackson.module.afterburner.deser.CreatorOptimizer;
import com.fasterxml.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import com.fasterxml.jackson.module.afterburner.deser.PropertyMutatorCollector;
import com.fasterxml.jackson.module.afterburner.deser.SuperSonicBeanDeserializer;
import com.fasterxml.jackson.module.afterburner.deser.SuperSonicDeserializerBuilder;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DeserializerModifier
extends BeanDeserializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final MyClassLoader _classLoader;
    protected final boolean _useCustomDeserializer;

    public DeserializerModifier(ClassLoader cl, boolean useCustomDeserializer) {
        this._classLoader = cl == null ? null : new MyClassLoader(cl, false);
        this._useCustomDeserializer = useCustomDeserializer;
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        ValueInstantiator inst;
        Class beanClass = beanDesc.getBeanClass();
        if (!MyClassLoader.canAddClassInPackageOf(beanClass)) {
            return builder;
        }
        if (this._classLoader != null && Modifier.isPrivate(beanClass.getModifiers())) {
            return builder;
        }
        PropertyMutatorCollector collector = new PropertyMutatorCollector(beanClass);
        List<OptimizedSettableBeanProperty<?>> newProps = this.findOptimizableProperties(config, collector, builder.getProperties());
        if (!newProps.isEmpty()) {
            BeanPropertyMutator baseMutator = collector.buildMutator(this._classLoader);
            for (OptimizedSettableBeanProperty<?> prop : newProps) {
                builder.addOrReplaceProperty(prop.withMutator(baseMutator), true);
            }
        }
        if ((inst = builder.getValueInstantiator()).getClass() == StdValueInstantiator.class && inst.canCreateUsingDefault() && (inst = new CreatorOptimizer(beanClass, this._classLoader, (StdValueInstantiator)inst).createOptimized()) != null) {
            builder.setValueInstantiator(inst);
        }
        if (this._useCustomDeserializer && builder.getClass() == BeanDeserializerBuilder.class) {
            return new SuperSonicDeserializerBuilder(builder);
        }
        return builder;
    }

    protected List<OptimizedSettableBeanProperty<?>> findOptimizableProperties(DeserializationConfig config, PropertyMutatorCollector collector, Iterator<SettableBeanProperty> propIterator) {
        ArrayList newProps = new ArrayList();
        while (propIterator.hasNext()) {
            Class type;
            SettableBeanProperty prop = propIterator.next();
            AnnotatedMember member = prop.getMember();
            Member jdkMember = member.getMember();
            if (jdkMember == null || Modifier.isPrivate(jdkMember.getModifiers()) || prop.hasValueDeserializer() && !this.isDefaultDeserializer(prop.getValueDeserializer())) continue;
            if (prop instanceof MethodProperty) {
                type = ((AnnotatedMethod)member).getRawParameterType(0);
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE) {
                        newProps.add(collector.addIntSetter(prop));
                        continue;
                    }
                    if (type == Long.TYPE) {
                        newProps.add(collector.addLongSetter(prop));
                        continue;
                    }
                    if (type != Boolean.TYPE) continue;
                    newProps.add(collector.addBooleanSetter(prop));
                    continue;
                }
                if (type == String.class) {
                    newProps.add(collector.addStringSetter(prop));
                    continue;
                }
                newProps.add(collector.addObjectSetter(prop));
                continue;
            }
            if (!(prop instanceof FieldProperty) || Modifier.isFinal(prop.getMember().getMember().getModifiers())) continue;
            type = member.getRawType();
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    newProps.add(collector.addIntField(prop));
                    continue;
                }
                if (type == Long.TYPE) {
                    newProps.add(collector.addLongField(prop));
                    continue;
                }
                if (type != Boolean.TYPE) continue;
                newProps.add(collector.addBooleanField(prop));
                continue;
            }
            if (type == String.class) {
                newProps.add(collector.addStringField(prop));
                continue;
            }
            newProps.add(collector.addObjectField(prop));
        }
        return newProps;
    }

    protected boolean isDefaultDeserializer(JsonDeserializer<?> deser) {
        return ClassUtil.isJacksonStdImpl(deser) || deser instanceof SuperSonicBeanDeserializer;
    }
}

