/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.persistence.api.entity.Realm;
import org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity;
import org.apache.syncope.core.persistence.jpa.entity.JPAConnPoolConf;
import org.apache.syncope.core.persistence.jpa.entity.JPAExternalResource;
import org.apache.syncope.core.persistence.jpa.entity.JPARealm;
import org.apache.syncope.core.persistence.jpa.validation.entity.ConnInstanceCheck;
import org.apache.syncope.core.provisioning.api.serialization.POJOHelper;

@Entity
@Table(name="ConnInstance")
@ConnInstanceCheck
public class JPAConnInstance
extends AbstractGeneratedKeyEntity
implements ConnInstance,
PersistenceCapable {
    private static final long serialVersionUID = -2294708794497208872L;
    public static final String TABLE = "ConnInstance";
    protected static final TypeReference<Set<ConnectorCapability>> TYPEREF = new TypeReference<Set<ConnectorCapability>>(){};
    private static final int DEFAULT_TIMEOUT = 10;
    @ManyToOne(fetch=FetchType.EAGER, optional=false)
    private JPARealm adminRealm;
    @NotNull
    private String location;
    @NotNull
    private String connectorName;
    @NotNull
    private String bundleName;
    @NotNull
    private String version;
    @Lob
    private String capabilities;
    private final Set<ConnectorCapability> capabilitiesSet = new HashSet<ConnectorCapability>();
    @Lob
    private String jsonConf;
    @Column(unique=true)
    private String displayName;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="connector")
    private List<JPAExternalResource> resources = new ArrayList<JPAExternalResource>();
    private Integer connRequestTimeout = 10;
    private JPAConnPoolConf poolConf;
    private static int pcInheritedFieldCount = AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$lang$Integer;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnPoolConf;
    static /* synthetic */ Class class$Ljava$util$List;
    static /* synthetic */ Class class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance;

    public Realm getAdminRealm() {
        return JPAConnInstance.pcGetadminRealm(this);
    }

    public void setAdminRealm(Realm adminRealm) {
        this.checkType(adminRealm, JPARealm.class);
        JPAConnInstance.pcSetadminRealm(this, (JPARealm)adminRealm);
    }

    public String getLocation() {
        return JPAConnInstance.pcGetlocation(this);
    }

    public void setLocation(String location) {
        JPAConnInstance.pcSetlocation(this, location);
    }

    public String getConnectorName() {
        return JPAConnInstance.pcGetconnectorName(this);
    }

    public void setConnectorName(String connectorName) {
        JPAConnInstance.pcSetconnectorName(this, connectorName);
    }

    public String getBundleName() {
        return JPAConnInstance.pcGetbundleName(this);
    }

    public void setBundleName(String bundleName) {
        JPAConnInstance.pcSetbundleName(this, bundleName);
    }

    public String getVersion() {
        return JPAConnInstance.pcGetversion(this);
    }

    public void setVersion(String version) {
        JPAConnInstance.pcSetversion(this, version);
    }

    public Set<ConnConfProperty> getConf() {
        HashSet<ConnConfProperty> configuration = new HashSet<ConnConfProperty>();
        if (!StringUtils.isBlank((CharSequence)JPAConnInstance.pcGetjsonConf(this))) {
            configuration.addAll(List.of((ConnConfProperty[])POJOHelper.deserialize((String)JPAConnInstance.pcGetjsonConf(this), ConnConfProperty[].class)));
        }
        return configuration;
    }

    public void setConf(Collection<ConnConfProperty> conf) {
        JPAConnInstance.pcSetjsonConf(this, POJOHelper.serialize(new HashSet<ConnConfProperty>(conf)));
    }

    public String getDisplayName() {
        return JPAConnInstance.pcGetdisplayName(this);
    }

    public void setDisplayName(String displayName) {
        JPAConnInstance.pcSetdisplayName(this, displayName);
    }

    public List<? extends ExternalResource> getResources() {
        return JPAConnInstance.pcGetresources(this);
    }

    public boolean add(ExternalResource resource) {
        this.checkType(resource, JPAExternalResource.class);
        return JPAConnInstance.pcGetresources(this).contains((JPAExternalResource)resource) || JPAConnInstance.pcGetresources(this).add((JPAExternalResource)resource);
    }

    public Set<ConnectorCapability> getCapabilities() {
        return this.capabilitiesSet;
    }

    public Integer getConnRequestTimeout() {
        return Optional.ofNullable(JPAConnInstance.pcGetconnRequestTimeout(this)).orElse(10);
    }

    public void setConnRequestTimeout(Integer timeout) {
        JPAConnInstance.pcSetconnRequestTimeout(this, timeout);
    }

    public ConnPoolConf getPoolConf() {
        return JPAConnInstance.pcGetpoolConf(this);
    }

    public void setPoolConf(ConnPoolConf poolConf) {
        this.checkType(poolConf, JPAConnPoolConf.class);
        JPAConnInstance.pcSetpoolConf(this, (JPAConnPoolConf)poolConf);
    }

    protected void json2list(boolean clearFirst) {
        if (clearFirst) {
            this.getCapabilities().clear();
        }
        if (JPAConnInstance.pcGetcapabilities(this) != null) {
            this.getCapabilities().addAll((Collection)POJOHelper.deserialize((String)JPAConnInstance.pcGetcapabilities(this), TYPEREF));
        }
    }

    @PostLoad
    public void postLoad() {
        this.json2list(false);
    }

    @PostPersist
    @PostUpdate
    public void postSave() {
        this.json2list(true);
    }

    @PrePersist
    @PreUpdate
    public void list2json() {
        JPAConnInstance.pcSetcapabilities(this, POJOHelper.serialize(this.getCapabilities()));
    }

    static {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity : (class$Lorg$apache$syncope$core$persistence$jpa$entity$AbstractGeneratedKeyEntity = JPAConnInstance.class$("org.apache.syncope.core.persistence.jpa.entity.AbstractGeneratedKeyEntity"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"adminRealm", "bundleName", "capabilities", "connRequestTimeout", "connectorName", "displayName", "jsonConf", "location", "poolConf", "resources", "version"};
        Class[] classArray = new Class[11];
        Class clazz2 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPARealm = JPAConnInstance.class$("org.apache.syncope.core.persistence.jpa.entity.JPARealm"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        classArray[1] = clazz3;
        classArray[2] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        Class clazz4 = class$Ljava$lang$Integer != null ? class$Ljava$lang$Integer : (class$Ljava$lang$Integer = JPAConnInstance.class$("java.lang.Integer"));
        classArray[3] = clazz4;
        classArray[4] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        Class clazz5 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnPoolConf != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnPoolConf : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnPoolConf = JPAConnInstance.class$("org.apache.syncope.core.persistence.jpa.entity.JPAConnPoolConf"));
        classArray[8] = clazz5;
        Class clazz6 = class$Ljava$util$List != null ? class$Ljava$util$List : (class$Ljava$util$List = JPAConnInstance.class$("java.util.List"));
        classArray[9] = clazz6;
        classArray[10] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = JPAConnInstance.class$("java.lang.String"));
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 5, 26};
        Class clazz7 = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance = JPAConnInstance.class$("org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance"));
        PCRegistry.register((Class)clazz7, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPAConnInstance", (PersistenceCapable)new JPAConnInstance());
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 196634845;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.adminRealm = null;
        this.bundleName = null;
        this.capabilities = null;
        this.connRequestTimeout = null;
        this.connectorName = null;
        this.displayName = null;
        this.jsonConf = null;
        this.location = null;
        this.poolConf = null;
        this.resources = null;
        this.version = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPAConnInstance jPAConnInstance = new JPAConnInstance();
        if (bl) {
            jPAConnInstance.pcClearFields();
        }
        jPAConnInstance.pcStateManager = stateManager;
        jPAConnInstance.pcCopyKeyFieldsFromObjectId(object);
        return jPAConnInstance;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPAConnInstance jPAConnInstance = new JPAConnInstance();
        if (bl) {
            jPAConnInstance.pcClearFields();
        }
        jPAConnInstance.pcStateManager = stateManager;
        return jPAConnInstance;
    }

    protected static int pcGetManagedFieldCount() {
        return 11 + AbstractGeneratedKeyEntity.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.adminRealm = (JPARealm)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.bundleName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.capabilities = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.connRequestTimeout = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.connectorName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.displayName = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.jsonConf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.location = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.poolConf = (JPAConnPoolConf)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.resources = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.version = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.adminRealm);
                return;
            }
            case 1: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.bundleName);
                return;
            }
            case 2: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.capabilities);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.connRequestTimeout);
                return;
            }
            case 4: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.connectorName);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.displayName);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.jsonConf);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.location);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.poolConf);
                return;
            }
            case 9: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.resources);
                return;
            }
            case 10: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.version);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(JPAConnInstance jPAConnInstance, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPAConnInstance, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.adminRealm = jPAConnInstance.adminRealm;
                return;
            }
            case 1: {
                this.bundleName = jPAConnInstance.bundleName;
                return;
            }
            case 2: {
                this.capabilities = jPAConnInstance.capabilities;
                return;
            }
            case 3: {
                this.connRequestTimeout = jPAConnInstance.connRequestTimeout;
                return;
            }
            case 4: {
                this.connectorName = jPAConnInstance.connectorName;
                return;
            }
            case 5: {
                this.displayName = jPAConnInstance.displayName;
                return;
            }
            case 6: {
                this.jsonConf = jPAConnInstance.jsonConf;
                return;
            }
            case 7: {
                this.location = jPAConnInstance.location;
                return;
            }
            case 8: {
                this.poolConf = jPAConnInstance.poolConf;
                return;
            }
            case 9: {
                this.resources = jPAConnInstance.resources;
                return;
            }
            case 10: {
                this.version = jPAConnInstance.version;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPAConnInstance jPAConnInstance = (JPAConnInstance)object;
        if (jPAConnInstance.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(jPAConnInstance, nArray[n]);
            ++n;
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        Class clazz = class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance != null ? class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance : (class$Lorg$apache$syncope$core$persistence$jpa$entity$JPAConnInstance = JPAConnInstance.class$("org.apache.syncope.core.persistence.jpa.entity.JPAConnInstance"));
        return clazz;
    }

    private static final JPARealm pcGetadminRealm(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.adminRealm;
        }
        int n = pcInheritedFieldCount + 0;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.adminRealm;
    }

    private static final void pcSetadminRealm(JPAConnInstance jPAConnInstance, JPARealm jPARealm) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.adminRealm = jPARealm;
            return;
        }
        jPAConnInstance.pcStateManager.settingObjectField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 0, (Object)jPAConnInstance.adminRealm, (Object)jPARealm, 0);
    }

    private static final String pcGetbundleName(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.bundleName;
        }
        int n = pcInheritedFieldCount + 1;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.bundleName;
    }

    private static final void pcSetbundleName(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.bundleName = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 1, jPAConnInstance.bundleName, string, 0);
    }

    private static final String pcGetcapabilities(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.capabilities;
        }
        int n = pcInheritedFieldCount + 2;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.capabilities;
    }

    private static final void pcSetcapabilities(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.capabilities = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 2, jPAConnInstance.capabilities, string, 0);
    }

    private static final Integer pcGetconnRequestTimeout(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.connRequestTimeout;
        }
        int n = pcInheritedFieldCount + 3;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.connRequestTimeout;
    }

    private static final void pcSetconnRequestTimeout(JPAConnInstance jPAConnInstance, Integer n) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.connRequestTimeout = n;
            return;
        }
        jPAConnInstance.pcStateManager.settingObjectField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 3, (Object)jPAConnInstance.connRequestTimeout, (Object)n, 0);
    }

    private static final String pcGetconnectorName(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.connectorName;
        }
        int n = pcInheritedFieldCount + 4;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.connectorName;
    }

    private static final void pcSetconnectorName(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.connectorName = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 4, jPAConnInstance.connectorName, string, 0);
    }

    private static final String pcGetdisplayName(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.displayName;
        }
        int n = pcInheritedFieldCount + 5;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.displayName;
    }

    private static final void pcSetdisplayName(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.displayName = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 5, jPAConnInstance.displayName, string, 0);
    }

    private static final String pcGetjsonConf(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.jsonConf;
        }
        int n = pcInheritedFieldCount + 6;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.jsonConf;
    }

    private static final void pcSetjsonConf(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.jsonConf = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 6, jPAConnInstance.jsonConf, string, 0);
    }

    private static final String pcGetlocation(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.location;
        }
        int n = pcInheritedFieldCount + 7;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.location;
    }

    private static final void pcSetlocation(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.location = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 7, jPAConnInstance.location, string, 0);
    }

    private static final JPAConnPoolConf pcGetpoolConf(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.poolConf;
        }
        int n = pcInheritedFieldCount + 8;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.poolConf;
    }

    private static final void pcSetpoolConf(JPAConnInstance jPAConnInstance, JPAConnPoolConf jPAConnPoolConf) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.poolConf = jPAConnPoolConf;
            return;
        }
        jPAConnInstance.pcStateManager.settingObjectField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 8, (Object)jPAConnInstance.poolConf, (Object)jPAConnPoolConf, 0);
    }

    private static final List pcGetresources(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.resources;
        }
        int n = pcInheritedFieldCount + 9;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.resources;
    }

    private static final void pcSetresources(JPAConnInstance jPAConnInstance, List list) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.resources = list;
            return;
        }
        jPAConnInstance.pcStateManager.settingObjectField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 9, jPAConnInstance.resources, (Object)list, 0);
    }

    private static final String pcGetversion(JPAConnInstance jPAConnInstance) {
        if (jPAConnInstance.pcStateManager == null) {
            return jPAConnInstance.version;
        }
        int n = pcInheritedFieldCount + 10;
        jPAConnInstance.pcStateManager.accessingField(n);
        return jPAConnInstance.version;
    }

    private static final void pcSetversion(JPAConnInstance jPAConnInstance, String string) {
        if (jPAConnInstance.pcStateManager == null) {
            jPAConnInstance.version = string;
            return;
        }
        jPAConnInstance.pcStateManager.settingStringField((PersistenceCapable)jPAConnInstance, pcInheritedFieldCount + 10, jPAConnInstance.version, string, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

