/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.cmd;

import java.io.Serializable;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.compatibility.Flowable5CompatibilityHandler;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.runtime.ProcessInstance;

public class SetProcessInstanceNameCmd
implements Command<Void>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String processInstanceId;
    protected String name;

    public SetProcessInstanceNameCmd(String processInstanceId, String name) {
        this.processInstanceId = processInstanceId;
        this.name = name;
    }

    public Void execute(CommandContext commandContext) {
        if (this.processInstanceId == null) {
            throw new FlowableIllegalArgumentException("processInstanceId is null");
        }
        ExecutionEntity execution = (ExecutionEntity)CommandContextUtil.getExecutionEntityManager(commandContext).findById(this.processInstanceId);
        if (execution == null) {
            ProcessInstance processInstance;
            Flowable5CompatibilityHandler compatibilityHandler;
            if (CommandContextUtil.getProcessEngineConfiguration(commandContext).isFlowable5CompatibilityEnabled() && (compatibilityHandler = Flowable5Util.getFlowable5CompatibilityHandler()) != null && (processInstance = compatibilityHandler.getProcessInstance(this.processInstanceId)) != null) {
                compatibilityHandler.setProcessInstanceName(processInstance.getId(), this.name);
                return null;
            }
            throw new FlowableObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist", ProcessInstance.class);
        }
        if (!execution.isProcessInstanceType()) {
            throw new FlowableObjectNotFoundException("process instance " + this.processInstanceId + " doesn't exist, the given ID references an execution, though", ProcessInstance.class);
        }
        if (execution.isSuspended()) {
            throw new FlowableException("process instance " + this.processInstanceId + " is suspended, cannot set name");
        }
        execution.setName(this.name);
        CommandContextUtil.getHistoryManager(commandContext).recordProcessInstanceNameChange(execution, this.name);
        return null;
    }
}

