/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.ext.scimv2.api.data;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import java.util.Map;
import org.apache.syncope.ext.scimv2.api.data.Meta;
import org.apache.syncope.ext.scimv2.api.data.SCIMExtensionInfo;
import org.apache.syncope.ext.scimv2.api.data.SCIMResource;

@JsonPropertyOrder(value={"schemas", "id", "externalId", "displayName", "extensionInfo", "meta"})
public class SCIMAnyObject
extends SCIMResource {
    @JsonIgnore
    private String extensionUrn;
    @JsonIgnore
    private SCIMExtensionInfo extensionInfo;

    @JsonCreator(mode=JsonCreator.Mode.PROPERTIES)
    public SCIMAnyObject(@JsonProperty(value="id") String id, @JsonProperty(value="schemas") List<String> schemas, @JsonProperty(value="meta") Meta meta, @JsonProperty(value="displayName") String displayName) {
        super(id, schemas, meta);
        super.setDisplayName(displayName);
        this.extensionUrn = schemas.isEmpty() ? null : schemas.get(0);
    }

    @JsonAnyGetter
    public Map<String, SCIMExtensionInfo> getExtensionAsMap() {
        if (this.extensionUrn != null && this.extensionInfo != null && !this.extensionInfo.isEmpty()) {
            return Map.of(this.extensionUrn, this.extensionInfo);
        }
        return Map.of();
    }

    @JsonAnySetter
    public void setDynamicExtension(String key, Object value) {
        if (key.startsWith("urn:ietf:params:scim:schemas:extension:syncope:2.0:")) {
            this.extensionUrn = key;
            if (value instanceof Map) {
                SCIMExtensionInfo info = new SCIMExtensionInfo();
                Map rawMap = (Map)value;
                for (Map.Entry entry : rawMap.entrySet()) {
                    info.add(entry.getKey().toString(), entry.getValue().toString());
                }
                this.extensionInfo = info;
            }
        }
    }

    public String getExtensionUrn() {
        return this.extensionUrn;
    }

    public void setExtensionUrn(String extensionUrn) {
        this.extensionUrn = extensionUrn;
    }

    public SCIMExtensionInfo getExtensionInfo() {
        return this.extensionInfo;
    }

    public void setExtensionInfo(SCIMExtensionInfo extensionInfo) {
        this.extensionInfo = extensionInfo;
    }
}

