/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.measure;

import java.io.Serializable;
import java.util.List;
import javax.measure.UnitConverter;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.measure.ConcatenatedConverter;
import org.apache.sis.measure.IdentityConverter;

public abstract class AbstractConverter
implements UnitConverter,
Serializable {
    private static final long serialVersionUID = -8480235641759297444L;

    protected AbstractConverter() {
    }

    public boolean isIdentity() {
        return false;
    }

    @Deprecated
    public boolean isLinear() {
        return this.isIdentity();
    }

    Number[] coefficients() {
        return this.isIdentity() ? new Number[]{} : null;
    }

    public Number convert(Number value) {
        return this.convert(value.doubleValue());
    }

    public abstract double derivative(double var1);

    static double derivative(UnitConverter converter, double value) {
        if (converter != null) {
            if (converter instanceof AbstractConverter) {
                return ((AbstractConverter)converter).derivative(value);
            }
            if (converter.isLinear()) {
                return converter.convert(1.0) - converter.convert(0.0);
            }
        }
        return Double.NaN;
    }

    static double scale(UnitConverter converter) {
        if (converter != null && converter.isLinear() && converter.convert(0.0) == 0.0) {
            return converter.convert(1.0);
        }
        return Double.NaN;
    }

    static double doubleValue(Number n) {
        return n instanceof Float ? DecimalFunctions.floatToDouble(n.floatValue()) : n.doubleValue();
    }

    static boolean epsilonEquals(double expected, double actual) {
        return Math.abs(expected - actual) <= Math.scalb(Math.ulp(expected), 4);
    }

    public UnitConverter concatenate(UnitConverter before) {
        if (this.equals(before.inverse())) {
            return IdentityConverter.INSTANCE;
        }
        return new ConcatenatedConverter(before, this);
    }

    public List<UnitConverter> getConversionSteps() {
        return List.of(this);
    }
}

