/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.image;

import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.image.internal.shared.ImageUtilities;
import org.apache.sis.math.NumberType;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.resources.Errors;

public enum DataType {
    BYTE(0, (byte)0),
    USHORT(1, (short)0),
    SHORT(2, (short)0),
    INT(3, 0),
    UINT(3, 0),
    FLOAT(4, Float.valueOf(Float.NaN)),
    DOUBLE(5, Double.NaN);

    private final int dataType;
    private final Number fillValue;
    private static final DataType[] VALUES;

    private DataType(int dataType, Number fillValue) {
        this.dataType = dataType;
        this.fillValue = fillValue;
    }

    public static DataType forBands(RenderedImage image) {
        return DataType.forBands(image.getSampleModel());
    }

    public static DataType forBands(SampleModel sm) {
        int type = sm.getDataType();
        if (type > 0 && type <= 3) {
            int numBits = 0;
            int i = sm.getNumBands();
            while (--i >= 0) {
                numBits = Math.max(numBits, sm.getSampleSize(i));
            }
            if (DataType.isUnsigned(sm)) {
                return numBits <= 8 ? BYTE : (numBits <= 16 ? USHORT : UINT);
            }
            return numBits <= 16 ? SHORT : INT;
        }
        return DataType.forDataBufferType(type);
    }

    public static DataType forRange(NumberRange<?> range, boolean forceInteger) {
        NumberType nt = NumberType.forClass((Class)range.getElementType()).orElse(NumberType.NULL);
        if (!forceInteger && nt.isFractional()) {
            return nt.isNarrowerThan(NumberType.DOUBLE) ? FLOAT : DOUBLE;
        }
        double min = range.getMinDouble();
        double max = range.getMaxDouble();
        if (!(nt.isReal() && nt.ordinal() < NumberType.LONG.ordinal() || min >= -1.67772165E7 && max < 1.67772165E7)) {
            return DOUBLE;
        }
        DataType type = min >= -0.5 && max < -0.5 ? (max < 255.5 ? BYTE : (max < 65535.5 ? USHORT : UINT)) : (min >= -32768.5 && max < 32767.5 ? SHORT : (min >= -2.1474836485E9 && max < 2.1474836475E9 ? INT : FLOAT));
        return type;
    }

    public static DataType forPrimitiveType(Class<?> type, boolean unsigned) {
        switch (NumberType.forClass(type).orElse(NumberType.NULL)) {
            case BYTE: {
                return unsigned ? BYTE : SHORT;
            }
            case SHORT: {
                return unsigned ? USHORT : SHORT;
            }
            case INTEGER: {
                return unsigned ? UINT : INT;
            }
            case FLOAT: {
                return FLOAT;
            }
            case DOUBLE: {
                return DOUBLE;
            }
        }
        throw new RasterFormatException(Resources.format((short)69, type));
    }

    public static DataType forDataBufferType(int type) {
        if (type >= 0 && type < VALUES.length) {
            return VALUES[type];
        }
        throw new RasterFormatException(Resources.format((short)69, type));
    }

    public static DataType forNumberOfBits(int size, boolean real, boolean signed) {
        if (size < 1 || size > 64 || Integer.lowestOneBit(size) != size) {
            throw new RasterFormatException(Errors.format((short)59, (Object)"size", (Object)size));
        }
        String argument = "real";
        boolean value = real;
        if (real) {
            switch (size) {
                case 32: {
                    return FLOAT;
                }
                case 64: {
                    return DOUBLE;
                }
            }
        } else if (size <= 32) {
            switch (size) {
                case 16: {
                    return signed ? SHORT : USHORT;
                }
                case 32: {
                    return signed ? INT : UINT;
                }
            }
            if (!signed) {
                return BYTE;
            }
            argument = "signed";
            value = signed;
        }
        throw new RasterFormatException(Resources.format((short)78, size, argument, value));
    }

    public final int size() {
        return DataBuffer.getDataTypeSize(this.dataType);
    }

    public final int bytes() {
        return this.size() >>> 3;
    }

    public final boolean isInteger() {
        return this.dataType <= 3;
    }

    public static boolean isInteger(SampleModel sm) {
        return sm != null && ImageUtilities.isIntegerType(sm.getDataType());
    }

    public final boolean isUnsigned() {
        return this.dataType <= 1 || this == UINT;
    }

    public static boolean isUnsigned(SampleModel sm) {
        int dataType;
        if (sm != null && (dataType = sm.getDataType()) >= 0) {
            if (dataType <= 1) {
                return true;
            }
            if (dataType <= 3) {
                return sm instanceof SinglePixelPackedSampleModel || sm instanceof MultiPixelPackedSampleModel;
            }
        }
        return false;
    }

    public final DataType toPrimitive() {
        switch (this.dataType) {
            default: {
                return this;
            }
            case 3: {
                return INT;
            }
            case 1: 
        }
        return SHORT;
    }

    public final DataType toFloat() {
        return this.dataType < 3 || this.dataType == 4 ? FLOAT : DOUBLE;
    }

    public final int toDataBufferType() {
        return this.dataType;
    }

    public final Number fillValue() {
        return this.fillValue;
    }

    static {
        VALUES = (DataType[])ArraysExt.remove((Object[])DataType.values(), (int)4, (int)1);
    }
}

