/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.client.ws;

import java.util.List;
import org.apache.servicecomb.common.rest.filter.HttpClientFilter;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.foundation.vertx.client.http.HttpClients;
import org.apache.servicecomb.foundation.vertx.client.ws.WebSocketClientWithContext;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.transport.rest.client.ws.WebSocketClientInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransportClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebSocketTransportClient.class);
    private final List<HttpClientFilter> httpClientFilters = SPIServiceUtils.getSortedService(HttpClientFilter.class);

    WebSocketTransportClient() {
    }

    public void send(Invocation invocation, AsyncResponse asyncResp) {
        WebSocketClientWithContext webSocketClientWithContext = this.findWebSocketPool(invocation);
        WebSocketClientInvocation webSocketClientInvocation = new WebSocketClientInvocation(webSocketClientWithContext, this.httpClientFilters);
        try {
            webSocketClientInvocation.invoke(invocation, asyncResp);
        }
        catch (Throwable e) {
            asyncResp.fail(invocation.getInvocationType(), e);
            LOGGER.error("vertx websocket transport send error.", e);
        }
    }

    protected WebSocketClientWithContext findWebSocketPool(Invocation invocation) {
        String clientName = "ws-transport-client";
        return HttpClients.getWebSocketClient((String)clientName, (boolean)invocation.isSync(), null);
    }
}

