/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import opennlp.tools.cmdline.AbstractCrossValidatorTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.namefind.NameEvaluationErrorListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderFineGrainedReportListener;
import opennlp.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import opennlp.tools.cmdline.namefind.TrainingParams;
import opennlp.tools.cmdline.params.CVParams;
import opennlp.tools.cmdline.params.FineGrainedEvaluatorParams;
import opennlp.tools.namefind.BilouCodec;
import opennlp.tools.namefind.BioCodec;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.namefind.NameSampleTypeFilter;
import opennlp.tools.namefind.TokenNameFinderCrossValidator;
import opennlp.tools.namefind.TokenNameFinderEvaluationMonitor;
import opennlp.tools.namefind.TokenNameFinderFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.SequenceCodec;
import opennlp.tools.util.TrainingParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TokenNameFinderCrossValidatorTool
extends AbstractCrossValidatorTool<NameSample, CVToolParams> {
    private static final Logger logger = LoggerFactory.getLogger(TokenNameFinderCrossValidatorTool.class);

    public TokenNameFinderCrossValidatorTool() {
        super(NameSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable Name Finder";
    }

    @Override
    public void run(String format, String[] args) {
        TokenNameFinderCrossValidator validator;
        TokenNameFinderFactory nameFinderFactory;
        SequenceCodec sequenceCodec;
        String sequenceCodecImplName;
        Map<String, Object> resources;
        super.run(format, args);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), true);
        if (this.mlParams == null) {
            this.mlParams = new TrainingParameters();
        }
        byte[] featureGeneratorBytes = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((CVToolParams)this.params).getFeaturegen());
        try {
            resources = TokenNameFinderTrainerTool.loadResources(((CVToolParams)this.params).getResources(), ((CVToolParams)this.params).getFeaturegen());
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while loading resources", (Throwable)e);
        }
        if (((CVToolParams)this.params).getNameTypes() != null) {
            String[] nameTypes = ((CVToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter(nameTypes, this.sampleStream);
        }
        LinkedList<Object> listeners = new LinkedList<Object>();
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            listeners.add(new NameEvaluationErrorListener());
        }
        if ("BIO".equals(sequenceCodecImplName = ((CVToolParams)this.params).getSequenceCodec())) {
            sequenceCodecImplName = BioCodec.class.getName();
        } else if ("BILOU".equals(sequenceCodecImplName)) {
            sequenceCodecImplName = BilouCodec.class.getName();
        }
        try {
            sequenceCodec = TokenNameFinderFactory.instantiateSequenceCodec((String)sequenceCodecImplName);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), (Throwable)e);
        }
        TokenNameFinderFineGrainedReportListener reportListener = null;
        File reportFile = ((CVToolParams)this.params).getReportOutputFile();
        FileOutputStream reportOutputStream = null;
        if (reportFile != null) {
            CmdLineUtil.checkOutputFile("Report Output File", reportFile);
            try {
                reportOutputStream = new FileOutputStream(reportFile);
                reportListener = new TokenNameFinderFineGrainedReportListener((SequenceCodec<String>)sequenceCodec, reportOutputStream);
                listeners.add(reportListener);
            }
            catch (FileNotFoundException e) {
                throw new TerminateToolException(-1, "IO error while creating Name Finder fine-grained report file: " + e.getMessage());
            }
        }
        try {
            nameFinderFactory = TokenNameFinderFactory.create((String)((CVToolParams)this.params).getFactory(), (byte[])featureGeneratorBytes, resources, (SequenceCodec)sequenceCodec);
        }
        catch (InvalidFormatException e) {
            throw new TerminateToolException(-1, e.getMessage(), (Throwable)e);
        }
        try {
            validator = new TokenNameFinderCrossValidator(((CVToolParams)this.params).getLang(), ((CVToolParams)this.params).getType(), this.mlParams, nameFinderFactory, listeners.toArray(new TokenNameFinderEvaluationMonitor[0]));
            validator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds().intValue());
        }
        catch (IOException e) {
            throw this.createTerminationIOException(e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        logger.info("done");
        if (reportFile != null) {
            reportListener.writeReport();
        }
        logger.info(validator.getFMeasure().toString());
    }

    static interface CVToolParams
    extends TrainingParams,
    CVParams,
    FineGrainedEvaluatorParams {
    }
}

