/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.model;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.ml.model.AbstractDataIndexer;
import opennlp.tools.ml.model.DataIndexer;
import opennlp.tools.ml.model.OnePassDataIndexer;
import opennlp.tools.ml.model.OnePassRealValueDataIndexer;
import opennlp.tools.ml.model.TwoPassDataIndexer;
import opennlp.tools.util.Parameters;
import opennlp.tools.util.ext.ExtensionLoader;

public class DataIndexerFactory {
    public static <P extends Parameters> DataIndexer<P> getDataIndexer(P parameters, Map<String, String> reportMap) {
        String indexerParam = parameters.getStringParameter("DataIndexer", "TwoPass");
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        AbstractDataIndexer indexer = switch (indexerParam) {
            case "OnePass" -> new OnePassDataIndexer();
            case "TwoPass" -> new TwoPassDataIndexer();
            case "OnePassRealValue" -> new OnePassRealValueDataIndexer();
            default -> (DataIndexer)ExtensionLoader.instantiateExtension(DataIndexer.class, (String)indexerParam);
        };
        indexer.init(parameters, reportMap);
        return indexer;
    }
}

