/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.service.mapper;

import java.util.Date;
import org.apache.nifi.flow.VersionedComponent;
import org.apache.nifi.registry.db.entity.BucketEntity;
import org.apache.nifi.registry.db.entity.BucketItemEntityType;
import org.apache.nifi.registry.db.entity.FlowEntity;
import org.apache.nifi.registry.db.entity.FlowSnapshotEntity;
import org.apache.nifi.registry.diff.ComponentDifference;
import org.apache.nifi.registry.diff.ComponentDifferenceGroup;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.flow.diff.FlowDifference;

public class FlowMappings {
    public static FlowEntity map(VersionedFlow versionedFlow) {
        FlowEntity flowEntity = new FlowEntity();
        flowEntity.setId(versionedFlow.getIdentifier());
        flowEntity.setName(versionedFlow.getName());
        flowEntity.setDescription(versionedFlow.getDescription());
        flowEntity.setCreated(new Date(versionedFlow.getCreatedTimestamp()));
        flowEntity.setModified(new Date(versionedFlow.getModifiedTimestamp()));
        flowEntity.setType(BucketItemEntityType.FLOW);
        return flowEntity;
    }

    public static VersionedFlow map(BucketEntity bucketEntity, FlowEntity flowEntity) {
        VersionedFlow versionedFlow = new VersionedFlow();
        versionedFlow.setIdentifier(flowEntity.getId());
        versionedFlow.setBucketIdentifier(flowEntity.getBucketId());
        versionedFlow.setName(flowEntity.getName());
        versionedFlow.setDescription(flowEntity.getDescription());
        versionedFlow.setCreatedTimestamp(flowEntity.getCreated().getTime());
        versionedFlow.setModifiedTimestamp(flowEntity.getModified().getTime());
        versionedFlow.setVersionCount(flowEntity.getSnapshotCount());
        if (bucketEntity != null) {
            versionedFlow.setBucketName(bucketEntity.getName());
        } else {
            versionedFlow.setBucketName(flowEntity.getBucketName());
        }
        return versionedFlow;
    }

    public static FlowSnapshotEntity map(VersionedFlowSnapshotMetadata versionedFlowSnapshot) {
        FlowSnapshotEntity flowSnapshotEntity = new FlowSnapshotEntity();
        flowSnapshotEntity.setFlowId(versionedFlowSnapshot.getFlowIdentifier());
        flowSnapshotEntity.setVersion(versionedFlowSnapshot.getVersion());
        flowSnapshotEntity.setComments(versionedFlowSnapshot.getComments());
        flowSnapshotEntity.setCreated(new Date(versionedFlowSnapshot.getTimestamp()));
        flowSnapshotEntity.setCreatedBy(versionedFlowSnapshot.getAuthor());
        return flowSnapshotEntity;
    }

    public static VersionedFlowSnapshotMetadata map(BucketEntity bucketEntity, FlowSnapshotEntity flowSnapshotEntity) {
        VersionedFlowSnapshotMetadata metadata = new VersionedFlowSnapshotMetadata();
        metadata.setFlowIdentifier(flowSnapshotEntity.getFlowId());
        metadata.setVersion(flowSnapshotEntity.getVersion().intValue());
        metadata.setComments(flowSnapshotEntity.getComments());
        metadata.setTimestamp(flowSnapshotEntity.getCreated().getTime());
        metadata.setAuthor(flowSnapshotEntity.getCreatedBy());
        if (bucketEntity != null) {
            metadata.setBucketIdentifier(bucketEntity.getId());
        }
        return metadata;
    }

    public static ComponentDifference map(FlowDifference flowDifference) {
        ComponentDifference diff = new ComponentDifference();
        diff.setChangeDescription(flowDifference.getDescription());
        diff.setDifferenceType(flowDifference.getDifferenceType().toString());
        diff.setDifferenceTypeDescription(flowDifference.getDifferenceType().getDescription());
        diff.setValueA(FlowMappings.getValueDescription(flowDifference.getValueA()));
        diff.setValueB(FlowMappings.getValueDescription(flowDifference.getValueB()));
        return diff;
    }

    public static ComponentDifferenceGroup map(VersionedComponent versionedComponent) {
        ComponentDifferenceGroup grouping = new ComponentDifferenceGroup();
        grouping.setComponentId(versionedComponent.getIdentifier());
        grouping.setComponentName(versionedComponent.getName());
        grouping.setProcessGroupId(versionedComponent.getGroupIdentifier());
        grouping.setComponentType(versionedComponent.getComponentType().getTypeName());
        return grouping;
    }

    private static String getValueDescription(Object valueA) {
        if (valueA instanceof VersionedComponent) {
            return ((VersionedComponent)valueA).getIdentifier();
        }
        if (valueA != null) {
            return valueA.toString();
        }
        return null;
    }
}

