/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.spring.boot;

import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginConfiguration;
import org.apache.logging.log4j.core.config.plugins.PluginLoggerContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.springframework.core.env.Environment;
import org.springframework.core.env.Profiles;
import org.springframework.util.StringUtils;

@Plugin(name="SpringProfile", category="Core", elementType="Arbiter", deferChildren=true, printObject=true)
public final class SpringProfileArbiter
implements Arbiter {
    private final String[] profileNames;
    private final Environment environment;

    private SpringProfileArbiter(String[] profiles, Environment environment) {
        this.profileNames = profiles;
        this.environment = environment;
    }

    public boolean isCondition() {
        if (this.environment == null) {
            return false;
        }
        if (this.profileNames.length == 0) {
            return false;
        }
        return this.environment.acceptsProfiles(Profiles.of((String[])this.profileNames));
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<SpringProfileArbiter> {
        private final Logger LOGGER = StatusLogger.getLogger();
        public static final String ATTR_NAME = "name";
        @PluginBuilderAttribute(value="name")
        private String name;
        @PluginConfiguration
        private Configuration configuration;
        @PluginLoggerContext
        private LoggerContext loggerContext;

        public Builder setName(String name) {
            this.name = name;
            return this.asBuilder();
        }

        public Builder setConfiguration(Configuration configuration) {
            this.configuration = configuration;
            return this.asBuilder();
        }

        public Builder setLoggerContext(LoggerContext loggerContext) {
            this.loggerContext = loggerContext;
            return this.asBuilder();
        }

        private Builder asBuilder() {
            return this;
        }

        public SpringProfileArbiter build() {
            String[] profileNames = StringUtils.trimArrayElements((String[])StringUtils.commaDelimitedListToStringArray((String)this.configuration.getStrSubstitutor().replace(this.name)));
            Environment environment = null;
            if (this.loggerContext != null) {
                environment = (Environment)this.loggerContext.getObject("SpringEnvironment");
                if (environment == null) {
                    this.LOGGER.debug("Creating Arbiter without a Spring Environment");
                }
                return new SpringProfileArbiter(profileNames, environment);
            }
            this.LOGGER.warn("Cannot create Arbiter, LoggerContext is not available");
            return null;
        }
    }
}

