/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.reflect;

import org.apache.juneau.commons.function.ThrowingConsumer2;
import org.apache.juneau.commons.function.ThrowingFunction;
import org.apache.juneau.commons.reflect.ExecutableException;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;

public class Property<T, V> {
    private final ThrowingFunction<T, V> producer;
    private final ThrowingConsumer2<T, V> consumer;

    public static <T, V> Builder<T, V> create() {
        return new Builder();
    }

    public Property(ThrowingFunction<T, V> producer, ThrowingConsumer2<T, V> consumer) {
        this.producer = producer;
        this.consumer = consumer;
    }

    public V get(T object) throws ExecutableException {
        AssertionUtils.assertArgNotNull("object", object);
        if (this.producer == null) {
            throw ThrowableUtils.exex("No getter defined for this property", new Object[0]);
        }
        return (V)Utils.safe(() -> this.producer.applyThrows(object));
    }

    public void set(T object, V value) throws ExecutableException {
        AssertionUtils.assertArgNotNull("object", object);
        if (this.consumer == null) {
            throw ThrowableUtils.exex("No setter defined for this property", new Object[0]);
        }
        Utils.safe(() -> this.consumer.acceptThrows(object, value));
    }

    public boolean canRead() {
        return this.producer != null;
    }

    public boolean canWrite() {
        return this.consumer != null;
    }

    public static class Builder<T, V> {
        private ThrowingFunction<T, V> producer;
        private ThrowingConsumer2<T, V> consumer;

        public Builder<T, V> getter(ThrowingFunction<T, V> producer) {
            this.producer = producer;
            return this;
        }

        public Builder<T, V> setter(ThrowingConsumer2<T, V> consumer) {
            this.consumer = consumer;
            return this;
        }

        public Builder<T, V> field(FieldInfo field) {
            AssertionUtils.assertArgNotNull("field", field);
            field.accessible();
            boolean isStatic = field.isStatic();
            this.producer = obj -> field.get(isStatic ? null : obj);
            this.consumer = (obj, val) -> field.set(isStatic ? null : obj, val);
            return this;
        }

        public Builder<T, V> getter(MethodInfo method) {
            AssertionUtils.assertArgNotNull("method", method);
            method.accessible();
            boolean isStatic = method.isStatic();
            this.producer = obj -> method.invoke(isStatic ? null : obj, new Object[0]);
            return this;
        }

        public Builder<T, V> setter(MethodInfo method) {
            AssertionUtils.assertArgNotNull("method", method);
            method.accessible();
            boolean isStatic = method.isStatic();
            this.consumer = (obj, val) -> method.invoke(isStatic ? null : obj, val);
            return this;
        }

        public Property<T, V> build() {
            return new Property<T, V>(this.producer, this.consumer);
        }
    }
}

