/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.juneau.annotation.Bean;

@Bean(bpi="exception,hash,count")
public class StackTraceInfo
implements Comparable<StackTraceInfo> {
    final AtomicInteger count;
    final long timeout;
    final String hash;
    final String exception;

    public StackTraceInfo(String exception, long timeout, int hash) {
        this.count = new AtomicInteger(0);
        this.timeout = timeout;
        this.hash = Integer.toHexString(hash);
        this.exception = exception;
    }

    private StackTraceInfo(String exception, int count, long timeout, String hash) {
        this.count = new AtomicInteger(count);
        this.timeout = timeout;
        this.hash = hash;
        this.exception = exception;
    }

    public int getCount() {
        return this.count.intValue();
    }

    public String getHash() {
        return this.hash;
    }

    public String getException() {
        return this.exception;
    }

    public StackTraceInfo increment() {
        this.count.incrementAndGet();
        return this;
    }

    @Override
    public int compareTo(StackTraceInfo o) {
        return Integer.compare(o.getCount(), this.getCount());
    }

    public StackTraceInfo clone() {
        return new StackTraceInfo(this.exception, this.count.intValue(), this.timeout, this.hash);
    }
}

