/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.reshandlers;

import java.io.IOException;
import java.io.Reader;
import org.apache.juneau.http.exception.HttpException;
import org.apache.juneau.http.exception.NotAcceptable;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.util.FinishablePrintWriter;
import org.apache.juneau.utils.IOPipe;

public final class ReaderHandler
implements ResponseHandler {
    @Override
    public boolean handle(RestRequest req, RestResponse res) throws IOException, NotAcceptable, HttpException {
        if (res.isOutputType(Reader.class)) {
            try (FinishablePrintWriter w = res.getNegotiatedWriter();){
                IOPipe.create(res.getOutput(Reader.class), w).run();
            }
            return true;
        }
        return false;
    }
}

