/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.VersionRange;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.RestMethod;

public class ClientVersionMatcher
extends RestMatcher {
    private final String clientVersionHeader;
    private final VersionRange range;

    protected ClientVersionMatcher(String clientVersionHeader, MethodInfo mi) {
        this.clientVersionHeader = StringUtils.isEmpty(clientVersionHeader) ? "X-Client-Version" : clientVersionHeader;
        RestMethod m = mi.getLastAnnotation(RestMethod.class);
        this.range = new VersionRange(m.clientVersion());
    }

    @Override
    public boolean matches(RestRequest req) {
        return this.range.matches(req.getHeader(this.clientVersionHeader));
    }

    @Override
    public boolean mustMatch() {
        return true;
    }
}

