/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jso;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.annotation.ConfigurableContext;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.jso.JsoBeanPropertyMeta;
import org.apache.juneau.jso.JsoClassMeta;
import org.apache.juneau.jso.JsoCommon;
import org.apache.juneau.jso.JsoMetaProvider;
import org.apache.juneau.jso.JsoParserBuilder;
import org.apache.juneau.jso.JsoParserSession;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParserSessionArgs;

@ConfigurableContext
public final class JsoParser
extends InputStreamParser
implements JsoMetaProvider,
JsoCommon {
    static final String PREFIX = "JsoParser";
    public static final JsoParser DEFAULT = new JsoParser(PropertyStore.DEFAULT);
    private final Map<ClassMeta<?>, JsoClassMeta> jsoClassMetas = new ConcurrentHashMap();
    private final Map<BeanPropertyMeta, JsoBeanPropertyMeta> jsoBeanPropertyMetas = new ConcurrentHashMap<BeanPropertyMeta, JsoBeanPropertyMeta>();

    public JsoParser(PropertyStore ps) {
        super(ps, "application/x-java-serialized-object");
    }

    @Override
    public JsoParserBuilder builder() {
        return new JsoParserBuilder(this.getPropertyStore());
    }

    public static JsoParserBuilder create() {
        return new JsoParserBuilder();
    }

    @Override
    public JsoParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    @Override
    public JsoParserSession createSession(ParserSessionArgs args) {
        return new JsoParserSession(args);
    }

    @Override
    public JsoClassMeta getJsoClassMeta(ClassMeta<?> cm) {
        JsoClassMeta m = this.jsoClassMetas.get(cm);
        if (m == null) {
            m = new JsoClassMeta(cm, this);
            this.jsoClassMetas.put(cm, m);
        }
        return m;
    }

    @Override
    public JsoBeanPropertyMeta getJsoBeanPropertyMeta(BeanPropertyMeta bpm) {
        if (bpm == null) {
            return JsoBeanPropertyMeta.DEFAULT;
        }
        JsoBeanPropertyMeta m = this.jsoBeanPropertyMetas.get(bpm);
        if (m == null) {
            m = new JsoBeanPropertyMeta(bpm.getDelegateFor(), this);
            this.jsoBeanPropertyMetas.put(bpm, m);
        }
        return m;
    }

    @Override
    public OMap toMap() {
        return super.toMap().a(PREFIX, new DefaultFilteringOMap());
    }
}

