/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import org.apache.juneau.internal.StringUtils;

public class SystemUtils {
    public static String getFirstString(String def, String ... keys) {
        for (String key : keys) {
            String v = System.getProperty(key);
            if (v == null) continue;
            return v;
        }
        return def;
    }

    public static Boolean getFirstBoolean(Boolean def, String ... keys) {
        String s = SystemUtils.getFirstString(null, keys);
        return s == null ? def : Boolean.parseBoolean(s);
    }

    public static Integer getFirstInteger(Integer def, String ... keys) {
        String s = SystemUtils.getFirstString(null, keys);
        return s == null ? def : Integer.parseInt(s);
    }

    public static void setProperty(String key, Object value, boolean overwrite) {
        if (value != null && (System.getProperty(key) == null || overwrite)) {
            System.setProperty(key, StringUtils.stringify(value));
        }
    }

    public static void setProperty(String key, Object value) {
        SystemUtils.setProperty(key, value, true);
    }
}

