/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReverseIterable<T>
implements Iterable<T> {
    private final List<T> list;

    public ReverseIterable(List<T> list) {
        this.list = list;
    }

    public static <T> ReverseIterable<T> of(List<T> list) {
        return new ReverseIterable<T>(list);
    }

    public static <T> ReverseIterable<T> of(T[] list) {
        return new ReverseIterable<T>(Arrays.asList(list));
    }

    @Override
    public Iterator<T> iterator() {
        final ListIterator<T> i = this.list.listIterator(this.list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return i.hasPrevious();
            }

            @Override
            public T next() {
                return i.previous();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }
}

