/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.Set;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.annotation.AnnotationUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jsonschema.annotation.ExternalDocs;
import org.apache.juneau.jsonschema.annotation.Items;
import org.apache.juneau.jsonschema.annotation.Schema;
import org.apache.juneau.jsonschema.annotation.SubItems;
import org.apache.juneau.parser.ParseException;

public class SchemaUtils {
    public static OMap asMap(Schema a) throws ParseException {
        if (a == null) {
            return OMap.EMPTY_MAP;
        }
        OMap om = new OMap();
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.ase("additionalProperties", SchemaUtils.toOMap(a.additionalProperties())).ase("allOf", SchemaUtils.joinnl(new String[][]{a.allOf()})).ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SchemaUtils.joinnl(a._default(), a.df())).ase("discriminator", a.discriminator()).ase("description", SchemaUtils.joinnl(a.description(), a.d())).ase("enum", SchemaUtils.toSet(a._enum()), SchemaUtils.toSet(a.e())).ase("examples", SchemaUtils.parseMap(a.examples()), SchemaUtils.parseMap(a.exs())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("externalDocs", SchemaUtils.merge(om.getMap("externalDocs"), a.externalDocs())).ase("format", a.format(), a.f()).ase("ignore", a.ignore() ? "true" : null).ase("items", SchemaUtils.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).asmo("maxProperties", a.maxProperties(), a.maxp()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).asmo("minProperties", a.minProperties(), a.minp()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("properties", SchemaUtils.toOMap(a.properties())).asf("readOnly", a.readOnly() || a.ro()).asf("required", a.required() || a.r()).ase("title", a.title()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("xml", SchemaUtils.joinnl(new String[][]{a.xml()})).ase("x-example", SchemaUtils.joinnl(a.example(), a.ex())).ase("$ref", a.$ref());
    }

    private static OMap toOMap(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SchemaUtils.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        if (!StringUtils.isJsonObject(s, true)) {
            s = "{" + s + "}";
        }
        return OMap.ofJson(s);
    }

    private static OMap parseMap(Object o) throws ParseException {
        if (o == null) {
            return null;
        }
        if (o instanceof String[]) {
            o = SchemaUtils.joinnl(new String[][]{(String[])o});
        }
        if (o instanceof String) {
            String s = o.toString();
            if (s.isEmpty()) {
                return null;
            }
            if ("IGNORE".equalsIgnoreCase(s)) {
                return OMap.of(new Object[]{"ignore", true});
            }
            if (!StringUtils.isJsonObject(s, true)) {
                s = "{" + s + "}";
            }
            return OMap.ofJson(s);
        }
        if (o instanceof OMap) {
            return (OMap)o;
        }
        throw new ParseException("Unexpected data type ''{0}''.  Expected OMap or String.", o.getClass().getName());
    }

    private static Set<String> toSet(String[] ss) throws ParseException {
        if (ss.length == 0) {
            return null;
        }
        String s = SchemaUtils.joinnl(new String[][]{ss});
        if (s.isEmpty()) {
            return null;
        }
        ASet<String> set = ASet.of(new String[0]);
        for (Object o : StringUtils.parseListOrCdl(s)) {
            set.add(o.toString());
        }
        return set;
    }

    private static OMap merge(OMap om, Items a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SchemaUtils.joinnl(a._default(), a.df())).ase("enum", SchemaUtils.toSet(a._enum()), SchemaUtils.toSet(a.e())).ase("format", a.format(), a.f()).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("items", SchemaUtils.merge(om.getMap("items"), a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("type", a.type(), a.t()).ase("$ref", a.$ref());
    }

    private static OMap merge(OMap om, SubItems a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.ase("collectionFormat", a.collectionFormat(), a.cf()).ase("default", SchemaUtils.joinnl(a._default(), a.df())).ase("enum", SchemaUtils.toSet(a._enum()), SchemaUtils.toSet(a.e())).asf("exclusiveMaximum", a.exclusiveMaximum() || a.emax()).asf("exclusiveMinimum", a.exclusiveMinimum() || a.emin()).ase("format", a.format(), a.f()).ase("items", SchemaUtils.toOMap(a.items())).ase("maximum", a.maximum(), a.max()).asmo("maxItems", a.maxItems(), a.maxi()).asmo("maxLength", a.maxLength(), a.maxl()).ase("minimum", a.minimum(), a.min()).asmo("minItems", a.minItems(), a.mini()).asmo("minLength", a.minLength(), a.minl()).ase("multipleOf", a.multipleOf(), a.mo()).ase("pattern", a.pattern(), a.p()).ase("type", a.type(), a.t()).asf("uniqueItems", a.uniqueItems() || a.ui()).ase("$ref", a.$ref());
    }

    private static OMap merge(OMap om, ExternalDocs a) throws ParseException {
        if (AnnotationUtils.empty(a)) {
            return om;
        }
        if (a.value().length > 0) {
            om.putAll(SchemaUtils.parseMap(a.value()));
        }
        return om.ase("description", SchemaUtils.joinnl(new String[][]{a.description()})).ase("url", a.url());
    }

    private static String joinnl(String[] ... s) {
        for (Object[] objectArray : s) {
            if (objectArray.length == 0) continue;
            return StringUtils.joinnl(objectArray).trim();
        }
        return "";
    }
}

