/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.NameValuePair;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.SerializedNameValuePair;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.VarResolver;

public class NameValuePairSupplier
implements Iterable<NameValuePair> {
    private final List<Iterable<NameValuePair>> pairs = new CopyOnWriteArrayList<Iterable<NameValuePair>>();
    private volatile VarResolver varResolver;

    public static NameValuePairSupplier create() {
        return new NameValuePairSupplier();
    }

    public static NameValuePairSupplier of() {
        return new NameValuePairSupplier();
    }

    public static NameValuePairSupplier of(Collection<NameValuePair> pairs) {
        return new NameValuePairSupplier().addAll(pairs);
    }

    public static NameValuePairSupplier ofPairs(Object ... parameters) {
        NameValuePairSupplier s = NameValuePairSupplier.create();
        if (parameters.length % 2 != 0) {
            throw new BasicRuntimeException("Odd number of parameters passed into NameValuePairSupplier.ofPairs()", new Object[0]);
        }
        for (int i = 0; i < parameters.length; i += 2) {
            s.add(StringUtils.stringify(parameters[i]), parameters[i + 1]);
        }
        return s;
    }

    public static NameValuePairSupplier of(Object ... values) {
        NameValuePairSupplier s = NameValuePairSupplier.create();
        for (Object v : values) {
            if (v instanceof NameValuePair) {
                s.add((NameValuePair)v);
                continue;
            }
            if (v instanceof NameValuePairSupplier) {
                s.add((NameValuePairSupplier)v);
                continue;
            }
            if (v == null) continue;
            throw new BasicRuntimeException("Invalid type passed to NameValuePairSupplier.of(): {0}", v.getClass().getName());
        }
        return s;
    }

    public NameValuePairSupplier resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public NameValuePairSupplier resolving(VarResolver varResolver) {
        this.varResolver = varResolver;
        return this;
    }

    public NameValuePairSupplier add(NameValuePair h) {
        if (h != null) {
            this.pairs.add(Collections.singleton(h));
        }
        return this;
    }

    public NameValuePairSupplier add(NameValuePairSupplier h) {
        if (h != null) {
            this.pairs.add(h);
        }
        return this;
    }

    private NameValuePairSupplier addAll(Collection<NameValuePair> pairs) {
        this.pairs.addAll(pairs.stream().filter(x -> x != null).map(x -> Collections.singleton(x)).collect(Collectors.toList()));
        return this;
    }

    public NameValuePairSupplier add(String name, Object value) {
        return this.add(new BasicNameValuePair(name, this.resolver(value)));
    }

    public NameValuePairSupplier add(String name, Supplier<?> value) {
        return this.add(new BasicNameValuePair(name, this.resolver(value)));
    }

    public NameValuePairSupplier add(String name, Object value, HttpPartType partType, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return this.add(new SerializedNameValuePair(name, this.resolver(value), partType, serializer, schema, skipIfEmpty));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (NameValuePair p : this) {
            String v = p.getValue();
            if (v == null) continue;
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(StringUtils.urlEncode(p.getName())).append('=').append(StringUtils.urlEncode(p.getValue()));
        }
        return sb.toString();
    }

    @Override
    public Iterator<NameValuePair> iterator() {
        return CollectionUtils.iterator(this.pairs);
    }

    public NameValuePair[] toArray() {
        ArrayList<NameValuePair> l = new ArrayList<NameValuePair>();
        for (NameValuePair p : this) {
            l.add(p);
        }
        return l.toArray(new NameValuePair[l.size()]);
    }

    public <T extends NameValuePair> T[] toArray(T[] array) {
        ArrayList<NameValuePair> l = new ArrayList<NameValuePair>();
        for (NameValuePair p : this) {
            l.add(p);
        }
        return (NameValuePair[])l.toArray(array);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver == null ? this.unwrap(input) : this.varResolver.resolve(StringUtils.stringify(this.unwrap(input)));
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }

    public static final class Null
    extends NameValuePairSupplier {
    }
}

