/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.SerializedHeader;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.marshall.SimpleJson;
import org.apache.juneau.svl.VarResolver;

public class HeaderSupplier
implements Iterable<Header> {
    private final List<Iterable<Header>> headers = new CopyOnWriteArrayList<Iterable<Header>>();
    private volatile VarResolver varResolver;

    public static HeaderSupplier create() {
        return new HeaderSupplier();
    }

    public static HeaderSupplier of() {
        return new HeaderSupplier();
    }

    public static HeaderSupplier of(Collection<Header> headers) {
        return new HeaderSupplier().addAll(headers);
    }

    public static HeaderSupplier ofPairs(Object ... parameters) {
        HeaderSupplier s = HeaderSupplier.create();
        if (parameters.length % 2 != 0) {
            throw new BasicRuntimeException("Odd number of parameters passed into HeaderSupplier.ofPairs()", new Object[0]);
        }
        for (int i = 0; i < parameters.length; i += 2) {
            s.add(StringUtils.stringify(parameters[i]), parameters[i + 1]);
        }
        return s;
    }

    public static HeaderSupplier of(Object ... values) {
        HeaderSupplier s = HeaderSupplier.create();
        for (Object v : values) {
            if (v instanceof Header) {
                s.add((Header)v);
                continue;
            }
            if (v instanceof HeaderSupplier) {
                s.add((HeaderSupplier)v);
                continue;
            }
            if (v == null) continue;
            throw new BasicRuntimeException("Invalid type passed to HeaderSupplier.of(): {0}", v.getClass().getName());
        }
        return s;
    }

    public HeaderSupplier resolving() {
        return this.resolving(VarResolver.DEFAULT);
    }

    public HeaderSupplier resolving(VarResolver varResolver) {
        this.varResolver = varResolver;
        return this;
    }

    public HeaderSupplier add(Header h) {
        if (h != null) {
            this.headers.add(Collections.singleton(h));
        }
        return this;
    }

    public HeaderSupplier add(HeaderSupplier h) {
        if (h != null) {
            this.headers.add(h);
        }
        return this;
    }

    private HeaderSupplier addAll(Collection<Header> headers) {
        this.headers.addAll(headers.stream().filter(x -> x != null).map(x -> Collections.singleton(x)).collect(Collectors.toList()));
        return this;
    }

    public HeaderSupplier add(String name, Object value) {
        return this.add(new BasicHeader(name, this.resolver(value)));
    }

    public HeaderSupplier add(String name, Supplier<?> value) {
        return this.add(new BasicHeader(name, this.resolver(value)));
    }

    public HeaderSupplier add(String name, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, boolean skipIfEmpty) {
        return this.add(new SerializedHeader(name, this.resolver(value), serializer, schema, skipIfEmpty));
    }

    public String toString() {
        return SimpleJson.DEFAULT.toString(this.toArray());
    }

    @Override
    public Iterator<Header> iterator() {
        return CollectionUtils.iterator(this.headers);
    }

    public Header[] toArray() {
        ArrayList<Header> l = new ArrayList<Header>();
        for (Header p : this) {
            l.add(p);
        }
        return l.toArray(new Header[l.size()]);
    }

    public <T extends Header> T[] toArray(T[] array) {
        ArrayList<Header> l = new ArrayList<Header>();
        for (Header p : this) {
            l.add(p);
        }
        return (Header[])l.toArray(array);
    }

    private Supplier<Object> resolver(Object input) {
        return () -> this.varResolver == null ? this.unwrap(input) : this.varResolver.resolve(StringUtils.stringify(this.unwrap(input)));
    }

    private Object unwrap(Object o) {
        while (o instanceof Supplier) {
            o = ((Supplier)o).get();
        }
        return o;
    }

    public static final class Null
    extends HeaderSupplier {
    }
}

