/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.html.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.juneau.html.HtmlRender;
import org.apache.juneau.html.annotation.Html;
import org.apache.juneau.html.annotation.HtmlFormat;
import org.apache.juneau.reflect.MethodInfo;

public class HtmlAnnotation
implements Html {
    private String on = "";
    private String anchorText = "";
    private String link = "";
    private HtmlFormat format = HtmlFormat.HTML;
    private boolean noTableHeaders = false;
    private boolean noTables = false;
    private Class<? extends HtmlRender> render = HtmlRender.class;

    public HtmlAnnotation(String on) {
        this.on(on);
    }

    public HtmlAnnotation(Class<?> on) {
        this.on(on);
    }

    public HtmlAnnotation(Method on) {
        this.on(on);
    }

    public HtmlAnnotation(Field on) {
        this.on(on);
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Html.class;
    }

    @Override
    public String anchorText() {
        return this.anchorText;
    }

    public HtmlAnnotation anchorText(String value) {
        this.anchorText = value;
        return this;
    }

    @Override
    public HtmlFormat format() {
        return this.format;
    }

    public HtmlAnnotation format(HtmlFormat value) {
        this.format = value;
        return this;
    }

    @Override
    public String link() {
        return this.link;
    }

    public HtmlAnnotation link(String value) {
        this.link = value;
        return this;
    }

    @Override
    public boolean noTableHeaders() {
        return this.noTableHeaders;
    }

    public HtmlAnnotation noTableHeaders(boolean value) {
        this.noTableHeaders = value;
        return this;
    }

    @Override
    public boolean noTables() {
        return this.noTables;
    }

    public HtmlAnnotation noTables(boolean value) {
        this.noTables = value;
        return this;
    }

    @Override
    public String on() {
        return this.on;
    }

    public HtmlAnnotation on(String value) {
        this.on = value;
        return this;
    }

    public HtmlAnnotation on(Class<?> value) {
        this.on = value.getName();
        return this;
    }

    public HtmlAnnotation on(Method value) {
        this.on = MethodInfo.of(value).getFullName();
        return this;
    }

    public HtmlAnnotation on(Field value) {
        this.on = value.getName();
        return this;
    }

    @Override
    public Class<? extends HtmlRender> render() {
        return this.render;
    }

    public HtmlAnnotation render(Class<? extends HtmlRender> value) {
        this.render = value;
        return this;
    }
}

