/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.json.SimpleJsonSerializer;

public class SessionArgs {
    public static final SessionArgs DEFAULT = new SessionArgs();
    OMap properties;

    @FluentSetter
    public SessionArgs debug(Boolean value) {
        this.property("Context.debug.b", value);
        return this;
    }

    @FluentSetter
    public SessionArgs locale(Locale value) {
        this.property("Context.locale.s", value);
        return this;
    }

    @FluentSetter
    public SessionArgs mediaType(MediaType value) {
        this.property("Context.mediaType.s", value);
        return this;
    }

    @FluentSetter
    public SessionArgs timeZone(TimeZone value) {
        this.property("Context.timeZone.s", value);
        return this;
    }

    @FluentSetter
    public SessionArgs properties(OMap value) {
        this.properties = value;
        return this;
    }

    @FluentSetter
    public SessionArgs property(String key, Object value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(key);
            }
        } else {
            if (this.properties == null) {
                this.properties = new OMap();
            }
            this.properties.put(key, value);
        }
        return this;
    }

    public Object getProperty(String key) {
        if (this.properties != null) {
            return this.properties.get(key);
        }
        return null;
    }

    public OMap toMap() {
        return new DefaultFilteringOMap().append("SessionArgs", new DefaultFilteringOMap().append("properties", this.properties));
    }

    public String toString() {
        return SimpleJsonSerializer.DEFAULT_READABLE.toString(this.toMap());
    }
}

