/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Query;

public class WithQuery
extends Node {
    private final Identifier name;
    private final Query query;
    @Nullable
    private final List<Identifier> columnNames;

    public WithQuery(Identifier name, Query query) {
        super(null);
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = null;
    }

    public WithQuery(Identifier name, Query query, List<Identifier> columnNames) {
        super(null);
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
    }

    public WithQuery(NodeLocation location, Identifier name, Query query) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = null;
    }

    public WithQuery(NodeLocation location, Identifier name, Query query, List<Identifier> columnNames) {
        super(Objects.requireNonNull(location, "location is null"));
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<List<Identifier>> getColumnNames() {
        return Optional.ofNullable(this.columnNames);
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.columnNames, o.columnNames);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WithQuery.sameClass(this, other)) {
            return false;
        }
        WithQuery otherRelation = (WithQuery)other;
        return this.name.equals(otherRelation.name) && Objects.equals(this.columnNames, otherRelation.columnNames);
    }
}

