/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.customizer.strategy;

import java.time.ZoneId;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class StateWindowAccessStrategy
implements AccessStrategy {
    private final long displayWindowBegin;
    private final long displayWindowEnd;
    private final double delta;
    private ZoneId zoneId;

    public StateWindowAccessStrategy(long displayWindowBegin, long displayWindowEnd, double delta) {
        this.displayWindowBegin = displayWindowBegin;
        this.displayWindowEnd = displayWindowEnd;
        this.delta = delta;
    }

    public StateWindowAccessStrategy(long displayWindowBegin, long displayWindowEnd) {
        this.displayWindowBegin = displayWindowBegin;
        this.displayWindowEnd = displayWindowEnd;
        this.delta = 0.0;
    }

    public StateWindowAccessStrategy(double delta) {
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
        this.delta = delta;
    }

    public StateWindowAccessStrategy() {
        this.displayWindowBegin = Long.MIN_VALUE;
        this.displayWindowEnd = Long.MAX_VALUE;
        this.delta = 0.0;
    }

    @Override
    public void check() {
        if (this.delta < 0.0) {
            throw new RuntimeException(String.format("Parameter delta(%f) should be positive or equal to 0.", this.delta));
        }
        if (this.displayWindowEnd < this.displayWindowBegin) {
            throw new RuntimeException(String.format("displayWindowEnd(%d) < displayWindowBegin(%d)", this.displayWindowEnd, this.displayWindowBegin));
        }
    }

    @Override
    public AccessStrategy.AccessStrategyType getAccessStrategyType() {
        return AccessStrategy.AccessStrategyType.STATE_WINDOW;
    }

    public long getDisplayWindowBegin() {
        return this.displayWindowBegin;
    }

    public long getDisplayWindowEnd() {
        return this.displayWindowEnd;
    }

    public double getDelta() {
        return this.delta;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }
}

