/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ServiceCounterDataType
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=871");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=872");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=873");
    private final UInteger totalCount;
    private final UInteger errorCount;

    public ServiceCounterDataType(UInteger totalCount, UInteger errorCount) {
        this.totalCount = totalCount;
        this.errorCount = errorCount;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public UInteger getTotalCount() {
        return this.totalCount;
    }

    public UInteger getErrorCount() {
        return this.errorCount;
    }

    protected ServiceCounterDataType(ServiceCounterDataTypeBuilder<?, ?> b) {
        super(b);
        this.totalCount = ((ServiceCounterDataTypeBuilder)b).totalCount;
        this.errorCount = ((ServiceCounterDataTypeBuilder)b).errorCount;
    }

    public static ServiceCounterDataTypeBuilder<?, ?> builder() {
        return new ServiceCounterDataTypeBuilderImpl();
    }

    public ServiceCounterDataTypeBuilder<?, ?> toBuilder() {
        return new ServiceCounterDataTypeBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServiceCounterDataType)) {
            return false;
        }
        ServiceCounterDataType other = (ServiceCounterDataType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$totalCount = this.getTotalCount();
        UInteger other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        UInteger this$errorCount = this.getErrorCount();
        UInteger other$errorCount = other.getErrorCount();
        return !(this$errorCount == null ? other$errorCount != null : !((Object)this$errorCount).equals(other$errorCount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServiceCounterDataType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        UInteger $errorCount = this.getErrorCount();
        result = result * 59 + ($errorCount == null ? 43 : ((Object)$errorCount).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ServiceCounterDataType(totalCount=" + this.getTotalCount() + ", errorCount=" + this.getErrorCount() + ")";
    }

    private static final class ServiceCounterDataTypeBuilderImpl
    extends ServiceCounterDataTypeBuilder<ServiceCounterDataType, ServiceCounterDataTypeBuilderImpl> {
        private ServiceCounterDataTypeBuilderImpl() {
        }

        @Override
        protected ServiceCounterDataTypeBuilderImpl self() {
            return this;
        }

        @Override
        public ServiceCounterDataType build() {
            return new ServiceCounterDataType(this);
        }
    }

    public static abstract class ServiceCounterDataTypeBuilder<C extends ServiceCounterDataType, B extends ServiceCounterDataTypeBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger totalCount;
        private UInteger errorCount;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ServiceCounterDataTypeBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ServiceCounterDataType instance, ServiceCounterDataTypeBuilder<?, ?> b) {
            b.totalCount(instance.totalCount);
            b.errorCount(instance.errorCount);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B totalCount(UInteger totalCount) {
            this.totalCount = totalCount;
            return (B)this.self();
        }

        public B errorCount(UInteger errorCount) {
            this.errorCount = errorCount;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ServiceCounterDataType.ServiceCounterDataTypeBuilder(super=" + super.toString() + ", totalCount=" + this.totalCount + ", errorCount=" + this.errorCount + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ServiceCounterDataType> {
        @Override
        public Class<ServiceCounterDataType> getType() {
            return ServiceCounterDataType.class;
        }

        @Override
        public ServiceCounterDataType decode(SerializationContext context, UaDecoder decoder) {
            UInteger totalCount = decoder.readUInt32("TotalCount");
            UInteger errorCount = decoder.readUInt32("ErrorCount");
            return new ServiceCounterDataType(totalCount, errorCount);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ServiceCounterDataType value) {
            encoder.writeUInt32("TotalCount", value.getTotalCount());
            encoder.writeUInt32("ErrorCount", value.getErrorCount());
        }
    }
}

