/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.storage.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.logger.Loggers;
import org.apache.ignite3.raft.jraft.error.RetryAgainException;
import org.apache.ignite3.raft.jraft.rpc.Message;
import org.apache.ignite3.raft.jraft.storage.io.FileReader;
import org.apache.ignite3.raft.jraft.util.ByteBufferCollector;

public class LocalDirReader
implements FileReader {
    private static final IgniteLogger LOG = Loggers.forClass(LocalDirReader.class);
    private final String path;

    public LocalDirReader(String path) {
        this.path = path;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public int readFile(ByteBufferCollector buf, String fileName, long offset, long maxCount) throws IOException, RetryAgainException {
        return this.readFileWithMeta(buf, fileName, null, offset, maxCount);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int readFileWithMeta(ByteBufferCollector buf, String fileName, Message fileMeta, long offset, long maxCount) throws IOException, RetryAgainException {
        buf.expandIfNecessary();
        String filePath = this.path + File.separator + fileName;
        File file = new File(filePath);
        try (FileInputStream input = new FileInputStream(file);
             FileChannel fc = input.getChannel();){
            int nread;
            int totalRead = 0;
            while (true) {
                if ((nread = fc.read(buf.getBuffer(), offset)) <= 0) {
                    int n = -1;
                    return n;
                }
                if ((long)(totalRead += nread) >= maxCount) break;
                if (buf.hasRemaining()) {
                    int n = -1;
                    return n;
                }
                buf.expandAtMost((int)(maxCount - (long)totalRead));
                offset += (long)nread;
            }
            long fsize = file.length();
            if (fsize < 0L) {
                LOG.warn("Invalid file length {}", filePath);
                int n = -1;
                return n;
            }
            if (fsize == offset + (long)nread) {
                int n = -1;
                return n;
            }
            int n = totalRead;
            return n;
        }
    }
}

