/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query;

import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class ColumnInformation {
    private final int ordinalPosition;
    private final String schemaName;
    private final String tblName;
    private final String colName;
    private final Class<?> fieldCls;
    private final boolean nullable;
    private final Object dfltVal;
    private final int precision;
    private final int scale;
    private final boolean affinityCol;

    public ColumnInformation(int ordinalPosition, String schemaName, String tblName, String colName, Class<?> fieldCls, boolean nullable, Object dfltVal, int precision, int scale, boolean affinityCol) {
        this.ordinalPosition = ordinalPosition;
        this.schemaName = schemaName;
        this.tblName = tblName;
        this.colName = colName;
        this.fieldCls = fieldCls;
        this.nullable = nullable;
        this.dfltVal = dfltVal;
        this.precision = precision;
        this.scale = scale;
        this.affinityCol = affinityCol;
    }

    public int columnId() {
        return this.ordinalPosition;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String tableName() {
        return this.tblName;
    }

    public String columnName() {
        return this.colName;
    }

    public Class<?> fieldClass() {
        return this.fieldCls;
    }

    public boolean nullable() {
        return this.nullable;
    }

    public Object defaultValue() {
        return this.dfltVal;
    }

    public int precision() {
        return this.precision;
    }

    public int scale() {
        return this.scale;
    }

    public boolean affinityColumn() {
        return this.affinityCol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInformation info = (ColumnInformation)o;
        return F.eq(this.schemaName, info.schemaName) && F.eq(this.tblName, info.tblName) && F.eq(this.colName, info.colName);
    }

    public int hashCode() {
        int res = this.schemaName != null ? this.schemaName.hashCode() : 0;
        res = 31 * res + (this.tblName != null ? this.tblName.hashCode() : 0);
        res = 31 * res + this.colName.hashCode();
        return res;
    }

    public String toString() {
        return S.toString(ColumnInformation.class, this);
    }
}

