/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.managers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridComponent;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.managers.GridManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.timeout.GridSpiTimeoutObject;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiNoop;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class GridManagerAdapter<T extends IgniteSpi>
implements GridManager {
    @GridToStringExclude
    protected final GridKernalContext ctx;
    @GridToStringExclude
    protected final IgniteLogger log;
    @GridToStringExclude
    private final T[] spis;
    private final boolean enabled;
    private final Map<IgniteSpi, Boolean> spiMap = new IdentityHashMap<IgniteSpi, Boolean>();
    @GridToStringExclude
    private boolean injected;

    protected GridManagerAdapter(GridKernalContext ctx, T ... spis) {
        assert (spis != null);
        assert (spis.length > 0);
        assert (ctx != null);
        this.ctx = ctx;
        this.spis = spis;
        boolean enabled = false;
        for (int i = 0; i < spis.length; ++i) {
            if (U.hasAnnotation(this.spis[i].getClass(), IgniteSpiNoop.class)) continue;
            enabled = true;
        }
        this.enabled = enabled;
        this.log = ctx.log(this.getClass());
    }

    protected final T getSpi() {
        return this.spis[0];
    }

    protected final T getSpi(@Nullable String name) {
        if (F.isEmpty(name)) {
            return this.spis[0];
        }
        for (T t : this.spis) {
            if (!t.getName().equals(name)) continue;
            return t;
        }
        throw new IgniteException("Failed to find SPI for name: " + name);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    protected final T[] getSpis() {
        return this.spis;
    }

    private void inject(IgniteSpi spi) throws IgniteCheckedException {
        Collection<Object> injectables;
        if (spi instanceof IgniteSpiAdapter && !F.isEmpty(injectables = ((IgniteSpiAdapter)spi).injectables())) {
            for (Object o : injectables) {
                this.ctx.resource().injectGeneric(o);
            }
        }
    }

    private void cleanup(IgniteSpi spi) throws IgniteCheckedException {
        Collection<Object> injectables;
        if (spi instanceof IgniteSpiAdapter && !F.isEmpty(injectables = ((IgniteSpiAdapter)spi).injectables())) {
            for (Object o : injectables) {
                this.ctx.resource().cleanupGeneric(o);
            }
        }
    }

    @Override
    public void onBeforeSpiStart() {
    }

    @Override
    public void onAfterSpiStart() {
    }

    @Override
    public void onDisconnected(IgniteFuture<?> reconnectFut) throws IgniteCheckedException {
        for (T t : this.spis) {
            t.onClientDisconnected(reconnectFut);
        }
    }

    @Override
    public IgniteInternalFuture<?> onReconnected(boolean clusterRestarted) throws IgniteCheckedException {
        for (T t : this.spis) {
            t.onClientReconnected(clusterRestarted);
        }
        return null;
    }

    protected void inject() throws IgniteCheckedException {
        if (this.injected) {
            return;
        }
        for (T spi : this.spis) {
            this.ctx.resource().inject((IgniteSpi)spi);
            this.inject((IgniteSpi)spi);
        }
        this.injected = true;
    }

    protected final void startSpi() throws IgniteCheckedException {
        HashSet names = U.newHashSet(this.spis.length);
        for (T spi : this.spis) {
            if (spi instanceof IgniteSpiAdapter) {
                ((IgniteSpiAdapter)spi).onBeforeStart();
            }
            Boolean res = this.spiMap.put((IgniteSpi)spi, Boolean.TRUE);
            assert (res == null);
            if (!this.injected) {
                this.ctx.resource().inject((IgniteSpi)spi);
                this.inject((IgniteSpi)spi);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Starting SPI: " + spi);
            }
            if (names.contains(spi.getName())) {
                throw new IgniteCheckedException("Duplicate SPI name (need to explicitly configure 'setName()' property): " + spi.getName());
            }
            names.add(spi.getName());
            if (this.log.isDebugEnabled()) {
                this.log.debug("Starting SPI implementation: " + spi.getClass().getName());
            }
            this.onBeforeSpiStart();
            try {
                spi.spiStart(this.ctx.igniteInstanceName());
            }
            catch (IgniteSpiException e) {
                throw new IgniteCheckedException("Failed to start SPI: " + spi, e);
            }
            this.onAfterSpiStart();
            this.parseNodeAttributes(spi);
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("SPI module started OK: " + spi.getClass().getName());
        }
        this.injected = true;
    }

    protected final void stopSpi() throws IgniteCheckedException {
        for (T spi : this.spis) {
            if (this.spiMap.remove(spi) == null) {
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Will not stop SPI since it has not been started by this manager: " + spi);
                continue;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Stopping SPI: " + spi);
            }
            try {
                spi.spiStop();
                if (this.log.isDebugEnabled()) {
                    this.log.debug("SPI module stopped OK: " + spi.getClass().getName());
                }
            }
            catch (IgniteSpiException e) {
                throw new IgniteCheckedException("Failed to stop SPI: " + spi, e);
            }
            try {
                this.cleanup((IgniteSpi)spi);
                this.ctx.resource().cleanup((IgniteSpi)spi);
            }
            catch (IgniteCheckedException e) {
                U.error(this.log, "Failed to remove injected resources from SPI (ignoring): " + spi, e);
            }
        }
    }

    protected final String startInfo() {
        return "Manager started ok: " + this.getClass().getName();
    }

    protected final String stopInfo() {
        return "Manager stopped ok: " + this.getClass().getName();
    }

    @Override
    public final void onKernalStart(boolean active) throws IgniteCheckedException {
        for (T spi : this.spis) {
            try {
                spi.onContextInitialized(new IgniteSpiContext((IgniteSpi)spi){
                    final /* synthetic */ IgniteSpi val$spi;
                    {
                        this.val$spi = igniteSpi;
                    }

                    @Override
                    public boolean isStopping() {
                        return GridManagerAdapter.this.ctx.isStopping();
                    }

                    @Override
                    public Collection<ClusterNode> remoteNodes() {
                        return GridManagerAdapter.this.ctx.discovery().remoteNodes();
                    }

                    @Override
                    public Collection<ClusterNode> nodes() {
                        return GridManagerAdapter.this.ctx.discovery().allNodes();
                    }

                    @Override
                    public ClusterNode localNode() {
                        return GridManagerAdapter.this.ctx.discovery().localNode();
                    }

                    @Override
                    @Nullable
                    public ClusterNode node(UUID nodeId) {
                        A.notNull(nodeId, "nodeId");
                        return GridManagerAdapter.this.ctx.discovery().node(nodeId);
                    }

                    @Override
                    public boolean pingNode(UUID nodeId) {
                        A.notNull(nodeId, "nodeId");
                        try {
                            return GridManagerAdapter.this.ctx.discovery().pingNode(nodeId);
                        }
                        catch (IgniteCheckedException e) {
                            throw U.convertException(e);
                        }
                    }

                    @Override
                    public void send(ClusterNode node, Serializable msg, String topic) throws IgniteSpiException {
                        A.notNull(node, "node");
                        A.notNull(msg, "msg");
                        A.notNull(topic, "topic");
                        try {
                            if (msg instanceof Message) {
                                GridManagerAdapter.this.ctx.io().sendToCustomTopic(node, (Object)topic, (Message)msg, (byte)2);
                            } else {
                                GridManagerAdapter.this.ctx.io().sendUserMessage(Collections.singletonList(node), msg, topic, false, 0L, false);
                            }
                        }
                        catch (IgniteCheckedException e) {
                            throw this.unwrapException(e);
                        }
                    }

                    @Override
                    public void addLocalMessageListener(Object topic, IgniteBiPredicate<UUID, ?> p) {
                        A.notNull(topic, "topic");
                        A.notNull(p, "p");
                        GridManagerAdapter.this.ctx.io().addUserMessageListener(topic, p);
                    }

                    @Override
                    public void removeLocalMessageListener(Object topic, IgniteBiPredicate<UUID, ?> p) {
                        A.notNull(topic, "topic");
                        A.notNull(topic, "p");
                        GridManagerAdapter.this.ctx.io().removeUserMessageListener(topic, p);
                    }

                    @Override
                    public void addMessageListener(GridMessageListener lsnr, String topic) {
                        A.notNull(lsnr, "lsnr");
                        A.notNull(topic, "topic");
                        GridManagerAdapter.this.ctx.io().addMessageListener(topic, lsnr);
                    }

                    @Override
                    public boolean removeMessageListener(GridMessageListener lsnr, String topic) {
                        A.notNull(lsnr, "lsnr");
                        A.notNull(topic, "topic");
                        return GridManagerAdapter.this.ctx.io().removeMessageListener(topic, lsnr);
                    }

                    @Override
                    public void addLocalEventListener(GridLocalEventListener lsnr, int ... types) {
                        A.notNull(lsnr, "lsnr");
                        GridManagerAdapter.this.ctx.event().addLocalEventListener(lsnr, types);
                    }

                    @Override
                    public boolean removeLocalEventListener(GridLocalEventListener lsnr) {
                        A.notNull(lsnr, "lsnr");
                        return GridManagerAdapter.this.ctx.event().removeLocalEventListener(lsnr, new int[0]);
                    }

                    @Override
                    public boolean isEventRecordable(int ... types) {
                        for (int t : types) {
                            if (GridManagerAdapter.this.ctx.event().isRecordable(t)) continue;
                            return false;
                        }
                        return true;
                    }

                    @Override
                    public void recordEvent(Event evt) {
                        A.notNull(evt, "evt");
                        if (GridManagerAdapter.this.ctx.event().isRecordable(evt.type())) {
                            GridManagerAdapter.this.ctx.event().record(evt);
                        }
                    }

                    @Override
                    public void registerPort(int port, IgnitePortProtocol proto) {
                        GridManagerAdapter.this.ctx.ports().registerPort(port, proto, this.val$spi.getClass());
                    }

                    @Override
                    public void deregisterPort(int port, IgnitePortProtocol proto) {
                        GridManagerAdapter.this.ctx.ports().deregisterPort(port, proto, this.val$spi.getClass());
                    }

                    @Override
                    public void deregisterPorts() {
                        GridManagerAdapter.this.ctx.ports().deregisterPorts(this.val$spi.getClass());
                    }

                    @Override
                    @Nullable
                    public <K, V> V get(String cacheName, K key) {
                        return GridManagerAdapter.this.ctx.cache().jcache(cacheName).get(key);
                    }

                    @Override
                    @Nullable
                    public <K, V> V put(String cacheName, K key, V val, long ttl) {
                        try {
                            if (ttl > 0L) {
                                TouchedExpiryPolicy plc = new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
                                IgniteCache<K, V> cache = GridManagerAdapter.this.ctx.cache().publicJCache(cacheName).withExpiryPolicy((ExpiryPolicy)plc);
                                return cache.getAndPut(key, val);
                            }
                            return GridManagerAdapter.this.ctx.cache().jcache(cacheName).getAndPut(key, val);
                        }
                        catch (IgniteCheckedException e) {
                            throw CU.convertToCacheException(e);
                        }
                    }

                    @Override
                    @Nullable
                    public <K, V> V putIfAbsent(String cacheName, K key, V val, long ttl) {
                        try {
                            if (ttl > 0L) {
                                TouchedExpiryPolicy plc = new TouchedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl));
                                IgniteCache<K, V> cache = GridManagerAdapter.this.ctx.cache().publicJCache(cacheName).withExpiryPolicy((ExpiryPolicy)plc);
                                return cache.getAndPutIfAbsent(key, val);
                            }
                            return GridManagerAdapter.this.ctx.cache().jcache(cacheName).getAndPutIfAbsent(key, val);
                        }
                        catch (IgniteCheckedException e) {
                            throw CU.convertToCacheException(e);
                        }
                    }

                    @Override
                    @Nullable
                    public <K, V> V remove(String cacheName, K key) {
                        return GridManagerAdapter.this.ctx.cache().jcache(cacheName).getAndRemove(key);
                    }

                    @Override
                    public <K> boolean containsKey(String cacheName, K key) {
                        return GridManagerAdapter.this.ctx.cache().cache(cacheName).containsKey(key);
                    }

                    @Override
                    public int partition(String cacheName, Object key) {
                        return GridManagerAdapter.this.ctx.cache().cache(cacheName).affinity().partition(key);
                    }

                    @Override
                    public IgniteNodeValidationResult validateNode(ClusterNode node) {
                        for (GridComponent comp : GridManagerAdapter.this.ctx) {
                            IgniteNodeValidationResult err = comp.validateNode(node);
                            if (err == null) continue;
                            return err;
                        }
                        return null;
                    }

                    @Override
                    @Nullable
                    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag discoData) {
                        for (GridComponent comp : GridManagerAdapter.this.ctx) {
                            IgniteNodeValidationResult err;
                            if (comp.discoveryDataType() == null || (err = comp.validateNode(node, discoData.newJoinerDiscoveryData(comp.discoveryDataType().ordinal()))) == null) continue;
                            return err;
                        }
                        return null;
                    }

                    @Override
                    public Collection<SecuritySubject> authenticatedSubjects() {
                        try {
                            return GridManagerAdapter.this.ctx.security().authenticatedSubjects();
                        }
                        catch (IgniteCheckedException e) {
                            throw U.convertException(e);
                        }
                    }

                    @Override
                    public SecuritySubject authenticatedSubject(UUID subjId) {
                        try {
                            return GridManagerAdapter.this.ctx.security().authenticatedSubject(subjId);
                        }
                        catch (IgniteCheckedException e) {
                            throw U.convertException(e);
                        }
                    }

                    @Override
                    public MessageFormatter messageFormatter() {
                        return GridManagerAdapter.this.ctx.io().formatter();
                    }

                    @Override
                    public MessageFactory messageFactory() {
                        return GridManagerAdapter.this.ctx.io().messageFactory();
                    }

                    @Override
                    public boolean tryFailNode(UUID nodeId, @Nullable String warning) {
                        return GridManagerAdapter.this.ctx.discovery().tryFailNode(nodeId, warning);
                    }

                    @Override
                    public void failNode(UUID nodeId, @Nullable String warning) {
                        GridManagerAdapter.this.ctx.discovery().failNode(nodeId, warning);
                    }

                    @Override
                    public void addTimeoutObject(IgniteSpiTimeoutObject obj) {
                        GridManagerAdapter.this.ctx.timeout().addTimeoutObject(new GridSpiTimeoutObject(obj));
                    }

                    @Override
                    public void removeTimeoutObject(IgniteSpiTimeoutObject obj) {
                        GridManagerAdapter.this.ctx.timeout().removeTimeoutObject(new GridSpiTimeoutObject(obj));
                    }

                    @Override
                    public Map<String, Object> nodeAttributes() {
                        return GridManagerAdapter.this.ctx.nodeAttributes();
                    }

                    @Override
                    public boolean communicationFailureResolveSupported() {
                        return GridManagerAdapter.this.ctx.discovery().communicationErrorResolveSupported();
                    }

                    @Override
                    public void resolveCommunicationFailure(ClusterNode node, Exception err) {
                        GridManagerAdapter.this.ctx.discovery().resolveCommunicationError(node, err);
                    }

                    @Override
                    public ReadOnlyMetricRegistry getOrCreateMetricRegistry(String name) {
                        return GridManagerAdapter.this.ctx.metric().registry(name);
                    }

                    @Override
                    public void removeMetricRegistry(String name) {
                        GridManagerAdapter.this.ctx.metric().remove(name);
                    }

                    @Override
                    public Iterable<ReadOnlyMetricRegistry> metricRegistries() {
                        return GridManagerAdapter.this.ctx.metric();
                    }

                    @Override
                    public void addMetricRegistryCreationListener(Consumer<ReadOnlyMetricRegistry> lsnr) {
                        GridManagerAdapter.this.ctx.metric().addMetricRegistryCreationListener(lsnr);
                    }

                    private IgniteSpiException unwrapException(IgniteCheckedException e) {
                        if (e.getCause() instanceof IgniteSpiException) {
                            return (IgniteSpiException)e.getCause();
                        }
                        return new IgniteSpiException("Failed to execute SPI context method.", e);
                    }
                });
            }
            catch (IgniteSpiException e) {
                throw new IgniteCheckedException("Failed to initialize SPI context.", e);
            }
        }
        this.onKernalStart0();
    }

    @Override
    public final void onKernalStop(boolean cancel) {
        this.onKernalStop0(cancel);
        for (T spi : this.spis) {
            spi.onContextDestroyed();
        }
    }

    @Override
    @Nullable
    public GridComponent.DiscoveryDataExchangeType discoveryDataType() {
        return null;
    }

    @Override
    public void collectJoiningNodeData(DiscoveryDataBag dataBag) {
    }

    @Override
    public void collectGridNodeData(DiscoveryDataBag dataBag) {
    }

    @Override
    public void onGridDataReceived(DiscoveryDataBag.GridDiscoveryData data) {
    }

    @Override
    public void onJoiningNodeDataReceived(DiscoveryDataBag.JoiningNodeDiscoveryData data) {
    }

    protected void onKernalStart0() throws IgniteCheckedException {
    }

    protected void onKernalStop0(boolean cancel) {
    }

    protected final void assertParameter(boolean cond, String condDesc) throws IgniteCheckedException {
        if (!cond) {
            throw new IgniteCheckedException("Grid configuration parameter failed condition check: " + condDesc);
        }
    }

    @Override
    public void printMemoryStats() {
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node) {
        return null;
    }

    @Override
    @Nullable
    public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag.JoiningNodeDiscoveryData discoData) {
        return null;
    }

    public final String toString() {
        return S.toString(GridManagerAdapter.class, this, "name", (Object)this.getClass().getName());
    }

    private void parseNodeAttributes(T spi) throws IgniteCheckedException {
        try {
            Map<String, Object> retval = spi.getNodeAttributes();
            if (retval != null) {
                for (Map.Entry<String, Object> e : retval.entrySet()) {
                    if (this.ctx.hasNodeAttribute(e.getKey())) {
                        throw new IgniteCheckedException("SPI attribute collision for attribute [spi=" + spi + ", attr=" + e.getKey() + "]. Attribute set by one SPI implementation has the same name (name collision) as attribute set by other SPI implementation. Such overriding is not allowed. Please check your Ignite configuration and/or SPI implementation to avoid attribute name collisions.");
                    }
                    this.ctx.addNodeAttribute(e.getKey(), e.getValue());
                }
            }
        }
        catch (IgniteSpiException e) {
            throw new IgniteCheckedException("Failed to get SPI attributes.", e);
        }
    }
}

