/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubWriteSchemaTransformConfiguration> {
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized PubsubMessage> OUTPUT_TAG = new TupleTag<PubsubMessage>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "RAW,AVRO,JSON";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"RAW,AVRO,JSON".split(","));

    public @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration> configurationClass() {
        return PubsubWriteSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration) {
        if (!VALID_DATA_FORMATS.contains(configuration.getFormat().toUpperCase())) {
            throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", configuration.getFormat(), VALID_FORMATS_STR));
        }
        return new PubsubWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsub_write:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList("input");
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("errors");
    }

    private static class PubsubWriteSchemaTransform
    extends SchemaTransform
    implements Serializable {
        final @UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration;

        PubsubWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized PubsubWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            SerializableFunction & Serializable fn;
            Schema payloadSchema;
            String errorOutput = this.configuration.getErrorHandling() == null ? null : this.configuration.getErrorHandling().getOutput();
            Schema errorSchema = Schema.builder().addStringField("error").addNullableRowField("row", input.get("input").getSchema()).build();
            String format = this.configuration.getFormat();
            Schema beamSchema = input.get("input").getSchema();
            if (this.configuration.getAttributes() == null && this.configuration.getAttributesMap() == null) {
                payloadSchema = beamSchema;
            } else {
                Schema.Builder payloadSchemaBuilder = Schema.builder();
                for (Schema.Field f : beamSchema.getFields()) {
                    if (this.configuration.getAttributes().contains(f.getName()) || f.getName().equals(this.configuration.getAttributesMap())) continue;
                    payloadSchemaBuilder.addField(f);
                }
                payloadSchema = payloadSchemaBuilder.build();
            }
            if (Objects.equals(format, "RAW")) {
                if (payloadSchema.getFieldCount() != 1) {
                    throw new IllegalArgumentException(String.format("Raw output only supported for single-field schemas, got %s", payloadSchema));
                }
                if (payloadSchema.getField(0).getType().equals((Object)Schema.FieldType.BYTES)) {
                    fn = (SerializableFunction & Serializable)row -> row.getBytes(0);
                } else {
                    if (!payloadSchema.getField(0).getType().equals((Object)Schema.FieldType.STRING)) throw new IllegalArgumentException(String.format("Raw output only supports bytes and string fields, got %s", payloadSchema.getField(0)));
                    fn = (SerializableFunction & Serializable)row -> row.getString(0).getBytes(StandardCharsets.UTF_8);
                }
            } else if (Objects.equals(format, "JSON")) {
                fn = JsonUtils.getRowToJsonBytesFunction((Schema)payloadSchema);
            } else {
                if (!Objects.equals(format, "AVRO")) throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", format, PubsubWriteSchemaTransformProvider.VALID_FORMATS_STR));
                fn = AvroUtils.getRowToAvroBytesFunction((Schema)payloadSchema);
            }
            PCollectionTuple outputTuple = (PCollectionTuple)input.get("input").apply((PTransform)ParDo.of((DoFn)new ErrorFn((SerializableFunction<Row, byte[]>)fn, this.configuration.getAttributes(), this.configuration.getAttributesMap(), payloadSchema, errorSchema, errorOutput != null)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
            PubsubIO.Write<PubsubMessage> writeTransform = PubsubIO.writeMessages().to(this.configuration.getTopic());
            if (!Strings.isNullOrEmpty((String)this.configuration.getIdAttribute())) {
                writeTransform = writeTransform.withIdAttribute(this.configuration.getIdAttribute());
            }
            if (!Strings.isNullOrEmpty((String)this.configuration.getTimestampAttribute())) {
                writeTransform = writeTransform.withIdAttribute(this.configuration.getTimestampAttribute());
            }
            outputTuple.get(OUTPUT_TAG).apply(writeTransform);
            outputTuple.get(ERROR_TAG).setRowSchema(errorSchema);
            if (errorOutput != null) return PCollectionRowTuple.of((String)errorOutput, (PCollection)outputTuple.get(ERROR_TAG).setRowSchema(errorSchema));
            return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
        }
    }

    public static class ErrorFn
    extends DoFn<Row, PubsubMessage> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> valueMapper;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> attributes;
        @javax.annotation.Nullable
        private final @UnknownKeyFor @Nullable @Initialized String attributesMap;
        private final @UnknownKeyFor @NonNull @Initialized Schema payloadSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema errorSchema;
        private final @UnknownKeyFor @NonNull @Initialized boolean useErrorOutput;

        ErrorFn(@UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> valueMapper, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> attributes, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String attributesMap, @UnknownKeyFor @NonNull @Initialized Schema payloadSchema, @UnknownKeyFor @NonNull @Initialized Schema errorSchema, @UnknownKeyFor @NonNull @Initialized boolean useErrorOutput) {
            this.valueMapper = valueMapper;
            this.attributes = attributes == null ? null : ImmutableSet.copyOf(attributes);
            this.attributesMap = attributesMap;
            this.payloadSchema = payloadSchema;
            this.errorSchema = errorSchema;
            this.useErrorOutput = useErrorOutput;
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) throws @UnknownKeyFor @NonNull @Initialized Exception {
            try {
                Row payloadRow;
                HashMap<String, String> messageAttributes = null;
                if (this.attributes == null && this.attributesMap == null) {
                    payloadRow = row;
                } else {
                    Row.Builder payloadRowBuilder = Row.withSchema((Schema)this.payloadSchema);
                    messageAttributes = new HashMap<String, String>();
                    List fields = row.getSchema().getFields();
                    for (int ix = 0; ix < fields.size(); ++ix) {
                        String name = ((Schema.Field)fields.get(ix)).getName();
                        if (this.attributes != null && this.attributes.contains(name)) {
                            messageAttributes.put(name, (String)row.getValue(ix));
                            continue;
                        }
                        if (name.equals(this.attributesMap)) {
                            Map attrs = row.getMap(ix);
                            if (attrs == null) continue;
                            messageAttributes.putAll(attrs);
                            continue;
                        }
                        payloadRowBuilder.addValue(row.getValue(ix));
                    }
                    payloadRow = payloadRowBuilder.build();
                }
                receiver.get(OUTPUT_TAG).output((Object)new PubsubMessage((byte[])this.valueMapper.apply((Object)payloadRow), messageAttributes));
            }
            catch (Exception e) {
                if (this.useErrorOutput) {
                    receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)this.errorSchema).addValues(new Object[]{e.toString(), row}).build());
                }
                throw e;
            }
        }
    }
}

