/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableBiFunction;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class StorageApiDynamicDestinationsBeamRow<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow;
    private final @Nullable @UnknownKeyFor @Initialized SerializableBiFunction<@Nullable @UnknownKeyFor @Initialized TableRowToStorageApiProto.SchemaInformation, T, @UnknownKeyFor @NonNull @Initialized TableRow> formatRecordOnFailureFunction;
    private final @UnknownKeyFor @NonNull @Initialized boolean usesCdc;

    StorageApiDynamicDestinationsBeamRow(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow, @Nullable @UnknownKeyFor @Initialized SerializableBiFunction<@Nullable @UnknownKeyFor @Initialized TableRowToStorageApiProto.SchemaInformation, T, @UnknownKeyFor @NonNull @Initialized TableRow> formatRecordOnFailureFunction, @UnknownKeyFor @NonNull @Initialized boolean usesCdc) {
        super(inner);
        this.tableSchema = BeamRowToStorageApiProto.protoTableSchemaFromBeamSchema(schema);
        this.toRow = toRow;
        this.formatRecordOnFailureFunction = formatRecordOnFailureFunction;
        this.usesCdc = usesCdc;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination,  @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new BeamRowConverter();
    }

    class BeamRowConverter
    implements StorageApiDynamicDestinations.MessageConverter<T> {
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable @UnknownKeyFor @Initialized Descriptors.Descriptor cdcDescriptor;

        BeamRowConverter() throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(StorageApiDynamicDestinationsBeamRow.this.tableSchema, true, false);
            this.cdcDescriptor = StorageApiDynamicDestinationsBeamRow.this.usesCdc ? TableRowToStorageApiProto.getDescriptorFromTableSchema((TableSchema)Preconditions.checkStateNotNull((Object)StorageApiDynamicDestinationsBeamRow.this.tableSchema), true, true) : null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableSchema getTableSchema() {
            return StorageApiDynamicDestinationsBeamRow.this.tableSchema;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto getDescriptor(@UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) {
            return this.cdcDescriptor != null ? this.cdcDescriptor.toProto() : this.descriptor.toProto();
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(T element, @Nullable @UnknownKeyFor @Initialized RowMutationInformation rowMutationInformation) throws @UnknownKeyFor @NonNull @Initialized Exception {
            String changeType = null;
            String changeSequenceNum = null;
            Descriptors.Descriptor descriptorToUse = this.descriptor;
            if (rowMutationInformation != null) {
                changeType = rowMutationInformation.getMutationType().toString();
                changeSequenceNum = rowMutationInformation.getChangeSequenceNumber();
                descriptorToUse = (Descriptors.Descriptor)Preconditions.checkStateNotNull((Object)this.cdcDescriptor);
            }
            DynamicMessage msg = BeamRowToStorageApiProto.messageFromBeamRow(descriptorToUse, (Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element), changeType, changeSequenceNum);
            return StorageApiWritePayload.of(msg.toByteArray(), null, StorageApiDynamicDestinationsBeamRow.this.formatRecordOnFailureFunction != null ? this.toFailsafeTableRow(element) : null);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableRow toFailsafeTableRow(T element) {
            if (StorageApiDynamicDestinationsBeamRow.this.formatRecordOnFailureFunction != null) {
                return (TableRow)StorageApiDynamicDestinationsBeamRow.this.formatRecordOnFailureFunction.apply(null, element);
            }
            return BigQueryUtils.toTableRow((Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element));
        }
    }
}

