/*
 * Decompiled with CFR 0.152.
 */
package com.epam.parso.impl;

import com.epam.parso.impl.Decompressor;
import java.util.Arrays;

final class BinDecompressor
implements Decompressor {
    static final BinDecompressor INSTANCE = new BinDecompressor();

    private BinDecompressor() {
    }

    @Override
    public byte[] decompressRow(int pageoffset, int srcLength, int resultLength, byte[] page) {
        byte[] srcRow = Arrays.copyOfRange(page, pageoffset, srcLength + pageoffset);
        byte[] outRow = new byte[resultLength];
        int srcOffset = 0;
        int outOffset = 0;
        int ctrlBits = 0;
        int ctrlMask = 0;
        block5: while (srcOffset < srcLength) {
            int ofs;
            if ((ctrlMask >>= 1) == 0) {
                ctrlBits = (srcRow[srcOffset] & 0xFF) << 8 | srcRow[srcOffset + 1] & 0xFF;
                srcOffset += 2;
                ctrlMask = 32768;
            }
            if ((ctrlBits & ctrlMask) == 0) {
                outRow[outOffset++] = srcRow[srcOffset++];
                continue;
            }
            int cmd = srcRow[srcOffset] >> 4 & 0xF;
            int cnt = srcRow[srcOffset++] & 0xF;
            switch (cmd) {
                case 0: {
                    int i;
                    cnt += 3;
                    for (i = 0; i < cnt; ++i) {
                        outRow[outOffset + i] = srcRow[srcOffset];
                    }
                    ++srcOffset;
                    outOffset += cnt;
                    continue block5;
                }
                case 1: {
                    int i;
                    cnt += (srcRow[srcOffset++] & 0xFF) << 4;
                    cnt += 19;
                    for (i = 0; i < cnt; ++i) {
                        outRow[outOffset + i] = srcRow[srcOffset];
                    }
                    ++srcOffset;
                    outOffset += cnt;
                    continue block5;
                }
                case 2: {
                    ofs = cnt + 3;
                    int n = srcOffset++;
                    cnt = srcRow[srcOffset++] & 0xFF;
                    System.arraycopy(outRow, outOffset - (ofs += (srcRow[n] & 0xFF) << 4), outRow, outOffset, cnt += 16);
                    outOffset += cnt;
                    continue block5;
                }
            }
            ofs = cnt + 3;
            System.arraycopy(outRow, outOffset - (ofs += (srcRow[srcOffset++] & 0xFF) << 4), outRow, outOffset, cmd);
            outOffset += cmd;
        }
        return outRow;
    }
}

