/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.io;

import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.io.MicrobatchSource;
import org.apache.beam.runners.spark.io.SourceRDD;
import org.apache.beam.sdk.io.Source;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.streaming.StreamingContext;
import org.apache.spark.streaming.Time;
import org.apache.spark.streaming.dstream.InputDStream;
import org.apache.spark.streaming.scheduler.RateController;
import org.apache.spark.streaming.scheduler.RateController$;
import org.apache.spark.streaming.scheduler.rate.RateEstimator;
import org.apache.spark.streaming.scheduler.rate.RateEstimator$;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.Tuple2;

class SourceDStream<@UnknownKeyFor T, @UnknownKeyFor CheckpointMarkT extends // Could not load outer class - annotation placement on inner may be incorrect
@UnknownKeyFor @NonNull @Initialized UnboundedSource.CheckpointMark>
extends InputDStream<Tuple2<Source<T>, CheckpointMarkT>> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SourceDStream.class);
    private final @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> unboundedSource;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;
    private final @UnknownKeyFor @NonNull @Initialized Duration boundReadDuration;
    private final @UnknownKeyFor @NonNull @Initialized double readerCacheInterval;
    private final @UnknownKeyFor @NonNull @Initialized int numPartitions;
    private final @UnknownKeyFor @NonNull @Initialized int initialParallelism;
    private final @UnknownKeyFor @NonNull @Initialized long boundMaxRecords;
    private final @UnknownKeyFor @NonNull @Initialized RateController rateController = new SourceRateController(this.id(), RateEstimator$.MODULE$.create(this.ssc().conf(), this.ssc().graph().batchDuration()));

    SourceDStream(@UnknownKeyFor @NonNull @Initialized StreamingContext ssc, @UnknownKeyFor @NonNull @Initialized UnboundedSource<T, CheckpointMarkT> unboundedSource, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options, @UnknownKeyFor @NonNull @Initialized Long boundMaxRecords) {
        super(ssc, JavaSparkContext$.MODULE$.fakeClassTag());
        this.unboundedSource = unboundedSource;
        this.options = options;
        SparkPipelineOptions sparkOptions = (SparkPipelineOptions)options.get().as(SparkPipelineOptions.class);
        this.readerCacheInterval = 1.5 * (double)sparkOptions.getBatchIntervalMillis().longValue();
        this.boundReadDuration = this.boundReadDuration(sparkOptions.getReadTimePercentage(), sparkOptions.getMinReadTimeMillis());
        this.initialParallelism = this.ssc().sparkContext().defaultParallelism();
        Preconditions.checkArgument((this.initialParallelism > 0 ? 1 : 0) != 0, (Object)"Number of partitions must be greater than zero.");
        this.boundMaxRecords = boundMaxRecords;
        try {
            this.numPartitions = this.createMicrobatchSource().split(sparkOptions).size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized RDD<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Source<T>, CheckpointMarkT>>> compute(@UnknownKeyFor @NonNull @Initialized Time validTime) {
        SourceRDD.Unbounded<T, CheckpointMarkT> rdd = new SourceRDD.Unbounded<T, CheckpointMarkT>(this.ssc().sparkContext(), this.options, this.createMicrobatchSource(), this.numPartitions);
        return Option.apply(rdd);
    }

    private @UnknownKeyFor @NonNull @Initialized MicrobatchSource<T, CheckpointMarkT> createMicrobatchSource() {
        return new MicrobatchSource<T, CheckpointMarkT>(this.unboundedSource, this.boundReadDuration, this.initialParallelism, this.computeReadMaxRecords(), -1, this.id(), this.readerCacheInterval);
    }

    private @UnknownKeyFor @NonNull @Initialized long computeReadMaxRecords() {
        if (this.boundMaxRecords > 0L) {
            LOG.info("Max records per batch has been set to {}, as configured in the PipelineOptions.", (Object)this.boundMaxRecords);
            return this.boundMaxRecords;
        }
        Option<Long> rateControlledMax = this.rateControlledMaxRecords();
        if (rateControlledMax.isDefined()) {
            LOG.info("Max records per batch has been set to {}, as advised by the rate controller.", rateControlledMax.get());
            return (Long)rateControlledMax.get();
        }
        LOG.info("Max records per batch has not been limited by neither configuration nor the rate controller, and will remain unlimited for the current batch ({}).", (Object)Long.MAX_VALUE);
        return Long.MAX_VALUE;
    }

    public void start() {
    }

    public void stop() {
    }

    public @UnknownKeyFor @NonNull @Initialized String name() {
        return "Beam UnboundedSource [" + this.id() + "]";
    }

    @UnknownKeyFor @NonNull @Initialized int getNumPartitions() {
        return this.numPartitions;
    }

    private @UnknownKeyFor @NonNull @Initialized Duration boundReadDuration(@UnknownKeyFor @NonNull @Initialized double readTimePercentage, @UnknownKeyFor @NonNull @Initialized long minReadTimeMillis) {
        Duration lowerBoundDuration;
        long batchDurationMillis = this.ssc().graph().batchDuration().milliseconds();
        Duration proportionalDuration = Duration.millis((long)Math.round((double)batchDurationMillis * readTimePercentage));
        Duration readDuration = proportionalDuration.isLongerThan((ReadableDuration)(lowerBoundDuration = Duration.millis((long)minReadTimeMillis))) ? proportionalDuration : lowerBoundDuration;
        LOG.info("Read duration set to: {}", (Object)readDuration);
        return readDuration;
    }

    private @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized Long> rateControlledMaxRecords() {
        Option rateLimitPerBatch;
        long rateLimitPerSec;
        Option<RateController> rateControllerOption = this.rateController();
        if (rateControllerOption.isDefined() && (rateLimitPerSec = ((RateController)rateControllerOption.get()).getLatestRate()) > 0L) {
            long batchDurationSec = this.ssc().graph().batchDuration().milliseconds() / 1000L;
            rateLimitPerBatch = Option.apply((Object)(rateLimitPerSec * batchDurationSec));
        } else {
            rateLimitPerBatch = Option.empty();
        }
        return rateLimitPerBatch;
    }

    public @UnknownKeyFor @NonNull @Initialized Option<@UnknownKeyFor @NonNull @Initialized RateController> rateController() {
        if (RateController$.MODULE$.isBackPressureEnabled(this.ssc().conf())) {
            return Option.apply((Object)this.rateController);
        }
        return Option.empty();
    }

    private static class SourceRateController
    extends RateController {
        private SourceRateController(@UnknownKeyFor @NonNull @Initialized int id, @UnknownKeyFor @NonNull @Initialized RateEstimator rateEstimator) {
            super(id, rateEstimator);
        }

        public void publish(@UnknownKeyFor @NonNull @Initialized long rate) {
        }
    }
}

